/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.restclient.utils;

import com.antfinancial.mychain.baas.tool.restclient.model.CallRestBizParam;
import com.antfinancial.mychain.baas.tool.restclient.model.Method;
import com.antfinancial.mychain.baas.tool.restclient.response.BaseResp;
import java.util.HashSet;
import java.util.Set;

public class CheckBizParam {
    private static final Set<Method> NEED_SIGN_METHOD = new HashSet<Method>();

    public static BaseResp checkParams(CallRestBizParam callRestBizParam) {
        BaseResp baseResp = new BaseResp();
        boolean passChecked = true;
        String data = "";
        if (CheckBizParam.isNullString(callRestBizParam.getAccessId())) {
            return BaseResp.builder().success(false).data("no access id").build();
        }
        if (CheckBizParam.isNullString(callRestBizParam.getToken())) {
            return BaseResp.builder().success(false).data("no token").build();
        }
        if (CheckBizParam.isNullString(callRestBizParam.getBizid())) {
            return BaseResp.builder().success(false).data("no bizid").build();
        }
        if (callRestBizParam.getMethod() == null) {
            return BaseResp.builder().success(false).data("no method").build();
        }
        if (NEED_SIGN_METHOD.contains((Object)callRestBizParam.getMethod()) && CheckBizParam.isNullString(callRestBizParam.getUid()) && CheckBizParam.isNullString(callRestBizParam.getMykmsKeyId())) {
            return BaseResp.builder().success(false).data("uid or mykmsKeyId must be not null").build();
        }
        if (!(Method.APPLYKEY.equals((Object)callRestBizParam.getMethod()) || Method.QUERYACCESSLIST.equals((Object)callRestBizParam.getMethod()) || Method.RESETAPPLYKEY.equals((Object)callRestBizParam.getMethod()) || Method.QUERYRECEIPT.equals((Object)callRestBizParam.getMethod()) || Method.QUERYTRANSACTION.equals((Object)callRestBizParam.getMethod()) || !CheckBizParam.isNullString(callRestBizParam.getOrderId()) || Method.FROZENTENANT.equals((Object)callRestBizParam.getMethod()) || Method.UNFROZENTENANT.equals((Object)callRestBizParam.getMethod()) || Method.QUERYKMSHOSTINGACCOUNT.equals((Object)callRestBizParam.getMethod()) || Method.SETGASHOLDACCOUNT.equals((Object)callRestBizParam.getMethod()) || Method.SyncTenantMaxTPS.equals((Object)callRestBizParam.getMethod()))) {
            return BaseResp.builder().success(false).data((Object)((Object)callRestBizParam.getMethod()) + " method must has orderId").build();
        }
        switch (callRestBizParam.getMethod()) {
            case DEPOSIT: {
                if (CheckBizParam.isNullString(callRestBizParam.getAccount())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has account";
                    break;
                }
                if (!CheckBizParam.isNullString(callRestBizParam.getContent())) break;
                passChecked = false;
                data = (Object)((Object)callRestBizParam.getMethod()) + " method must has content";
                break;
            }
            case CALLCONTRACTBIZ: 
            case CALLCONTRACTBIZASYNC: 
            case CALLWASMCONTRACT: 
            case CALLWASMCONTRACTASYNC: {
                if (CheckBizParam.isNullString(callRestBizParam.getAccount())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has account";
                    break;
                }
                if (CheckBizParam.isNullString(callRestBizParam.getContractName())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has contract name";
                    break;
                }
                if (CheckBizParam.isNullString(callRestBizParam.getOutTypes())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has outTypes";
                    break;
                }
                if (CheckBizParam.isNullString(callRestBizParam.getMethodSignature())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has methodSignature";
                    break;
                }
                if (!CheckBizParam.isNullString(callRestBizParam.getInputParamListStr())) break;
                passChecked = false;
                data = (Object)((Object)callRestBizParam.getMethod()) + " method must has inputParamListStr";
                break;
            }
            case CALLNATIVECONTRACTFORBIZASYNC: 
            case CALLNATIVECONTRACTFORBIZ: {
                if (CheckBizParam.isNullString(callRestBizParam.getAccount())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has account";
                    break;
                }
                if (CheckBizParam.isNullString(callRestBizParam.getContractName())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has contract name";
                    break;
                }
                if (CheckBizParam.isNullString(callRestBizParam.getMethodSignature())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has methodSignature";
                    break;
                }
                if (!CheckBizParam.isNullString(callRestBizParam.getNativeContractData())) break;
                passChecked = false;
                data = (Object)((Object)callRestBizParam.getMethod()) + " method must has nativeContractData";
                break;
            }
            case QUERYRECEIPT: 
            case QUERYTRANSACTION: {
                if (!CheckBizParam.isNullString(callRestBizParam.getHash())) break;
                passChecked = false;
                data = (Object)((Object)callRestBizParam.getMethod()) + " method must has hash";
                break;
            }
            case DEPLOYCONTRACTFORBIZ: 
            case DEPLOYWASMCONTRACT: 
            case UPDATECONTRACTFORBIZ: {
                if (CheckBizParam.isNullString(callRestBizParam.getAccount())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has account";
                    break;
                }
                if (CheckBizParam.isNullString(callRestBizParam.getContractName())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has contract name";
                    break;
                }
                if (!CheckBizParam.isNullString(callRestBizParam.getContractCode())) break;
                passChecked = false;
                data = (Object)((Object)callRestBizParam.getMethod()) + " method must has contractCode";
                break;
            }
            case CREATEACCOUNT: {
                if (CheckBizParam.isNullString(callRestBizParam.getAccount())) {
                    passChecked = false;
                    data = (Object)((Object)callRestBizParam.getMethod()) + " method must has account";
                    break;
                }
                if (!CheckBizParam.isNullString(callRestBizParam.getMykmsKeyId())) break;
                passChecked = false;
                data = (Object)((Object)callRestBizParam.getMethod()) + " method must has mykmsKeyId";
            }
        }
        baseResp.setSuccess(passChecked);
        baseResp.setData(data);
        return baseResp;
    }

    public static boolean isNullString(String s) {
        return s == null || "".equals(s);
    }

    static {
        NEED_SIGN_METHOD.add(Method.DEPOSIT);
        NEED_SIGN_METHOD.add(Method.DEPLOYCONTRACTFORBIZ);
        NEED_SIGN_METHOD.add(Method.CALLWASMCONTRACT);
        NEED_SIGN_METHOD.add(Method.CALLWASMCONTRACTASYNC);
        NEED_SIGN_METHOD.add(Method.CALLCONTRACTBIZ);
        NEED_SIGN_METHOD.add(Method.CALLCONTRACTBIZASYNC);
    }
}

