/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.utils;

import com.alibaba.fastjson.JSONArray;
import com.alipay.mychain.sdk.api.utils.Utils;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.vm.NativeCallParameters;
import com.antfinancial.mychain.baas.tool.utils.SolidityVarType;
import java.util.ArrayList;
import java.util.List;

public class NativeContractParameterUtils {
    public static byte[] rlpEncodeSingleTemplate(String[] templateArg, JSONArray jsonArray) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        block5: for (int i = 0; i < templateArg.length; ++i) {
            switch (SolidityVarType.fromCode(templateArg[i])) {
                case INT: {
                    data.add(Rlp.encodeInt(jsonArray.getIntValue(i)));
                    continue block5;
                }
                case INT64: {
                    data.add(Rlp.encodeLong(jsonArray.getLongValue(i)));
                    continue block5;
                }
                case STRING: {
                    data.add(Rlp.encodeString(jsonArray.getString(i)));
                    continue block5;
                }
                default: {
                    throw new RuntimeException("unsupported template param type");
                }
            }
        }
        return Rlp.encodeList(data);
    }

    public static byte[] rlpEncodeTemplate(String template, String inputParam) {
        String[] templateArg = template.split(",");
        JSONArray inputParamList = JSONArray.parseArray((String)inputParam);
        if (inputParamList.get(0) instanceof JSONArray) {
            ArrayList<byte[]> data = new ArrayList<byte[]>();
            for (int i = 0; i < inputParamList.size(); ++i) {
                data.add(NativeContractParameterUtils.rlpEncodeSingleTemplate(templateArg, (JSONArray)inputParamList.get(0)));
            }
            return Rlp.encodeList(data);
        }
        return NativeContractParameterUtils.rlpEncodeSingleTemplate(templateArg, inputParamList);
    }

    public static void addParameter4Contract(NativeCallParameters nativeCallParameters, String methodSignature, String nativeContractData) {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        String argStr = methodSignature.substring(methodSignature.indexOf(40) + 1, methodSignature.indexOf(41));
        String[] args = argStr.length() > 0 ? argStr.split(",") : new String[]{};
        JSONArray inputParamList = JSONArray.parseArray((String)nativeContractData);
        String methodName = methodSignature.substring(0, methodSignature.lastIndexOf(40));
        data.add(Rlp.encodeString(methodName));
        block13: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            switch (SolidityVarType.fromCode(arg)) {
                case INT: {
                    data.add(Rlp.encodeInt(inputParamList.getIntValue(i)));
                    continue block13;
                }
                case INT64: {
                    data.add(Rlp.encodeLong(inputParamList.getLongValue(i)));
                    continue block13;
                }
                case IDENTITY: {
                    data.add(Rlp.encodeElement(Utils.getIdentityByName(inputParamList.getString(i)).getValue()));
                    continue block13;
                }
                case STRING: {
                    try {
                        data.add(Rlp.encodeElement(inputParamList.getString(i).getBytes("utf-8")));
                        continue block13;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                case INT_ARRAY: {
                    List params = inputParamList.getJSONArray(i).toJavaList(Integer.class);
                    ArrayList<byte[]> nums = new ArrayList<byte[]>();
                    for (Integer p : params) {
                        nums.add(Rlp.encodeInt(p));
                    }
                    data.add(Rlp.encodeList(nums));
                    continue block13;
                }
                case INT64_ARRAY: {
                    List longList = inputParamList.getJSONArray(i).toJavaList(Long.class);
                    ArrayList<byte[]> longBytesList = new ArrayList<byte[]>();
                    for (Long p : longList) {
                        longBytesList.add(Rlp.encodeLong(p));
                    }
                    data.add(Rlp.encodeList(longBytesList));
                    continue block13;
                }
                case BYTES: {
                    data.add(Rlp.encodeElement((byte[])inputParamList.getObject(i, byte[].class)));
                    continue block13;
                }
                case ENCODEDBYTES: {
                    data.add((byte[])inputParamList.getObject(i, byte[].class));
                    continue block13;
                }
                case BYTES_LIST: {
                    JSONArray jsonArray1 = inputParamList.getJSONArray(i);
                    ArrayList<byte[]> bytesList = new ArrayList<byte[]>();
                    for (int idx = 0; idx < jsonArray1.size(); ++idx) {
                        bytesList.add(Rlp.encodeElement((byte[])jsonArray1.getObject(idx, byte[].class)));
                    }
                    data.add(Rlp.encodeList(bytesList));
                    continue block13;
                }
                default: {
                    throw new RuntimeException("Unsupported function parameter type: " + arg);
                }
            }
        }
        nativeCallParameters.setData(Rlp.encodeList(data));
    }
}

