/*
 * Decompiled with CFR 0.152.
 */
package com.antfinancial.mychain.baas.tool.utils;

import com.alibaba.fastjson.JSONArray;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.vm.WASMOutput;
import com.alipay.mychain.sdk.vm.WASMParameter;
import com.alipay.mychain.sdk.vm.abi.datatype.Int16;
import com.alipay.mychain.sdk.vm.abi.datatype.Int32;
import com.alipay.mychain.sdk.vm.abi.datatype.Int64;
import com.alipay.mychain.sdk.vm.abi.datatype.Int8;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint16;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint32;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint64;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint8;
import com.antfinancial.mychain.baas.tool.utils.WasmParaType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WasmParaUtils {
    public static void addParameter4Wasm(WASMParameter wasmContractParameters, String methodSignature, String inputParamStr) {
        String argOr = methodSignature.substring(methodSignature.indexOf(40) + 1).replace(")", "");
        String[] args = new String[]{};
        if (argOr.length() > 0) {
            args = argOr.split(",");
        }
        JSONArray inputParamList = JSONArray.parseArray((String)inputParamStr);
        WasmParaUtils.addParameter4Wasm(wasmContractParameters, inputParamList, args);
    }

    public static void addParameter4Wasm(WASMParameter wasmContractParameters, JSONArray inputParamList, String[] args) {
        int index = 0;
        for (String arg : args) {
            int i;
            if (arg.equals(WasmParaType.INT8.getName())) {
                wasmContractParameters.addInt8(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.INT16.getName())) {
                wasmContractParameters.addInt16(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.INT32.getName())) {
                wasmContractParameters.addInt32(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.INT64.getName())) {
                wasmContractParameters.addInt64(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.VECTORINT8.getName()) || arg.equals(WasmParaType.VECTORINT16.getName()) || arg.equals(WasmParaType.VECTORINT32.getName()) || arg.equals(WasmParaType.VECTORINT64.getName()) || arg.equals(WasmParaType.VECTORUINT8.getName()) || arg.equals(WasmParaType.VECTORUINT16.getName()) || arg.equals(WasmParaType.VECTORUINT32.getName()) || arg.equals(WasmParaType.VECTORUINT64.getName())) {
                JSONArray vectorInt = inputParamList.getJSONArray(index++);
                LinkedList<BigInteger> nums = new LinkedList<BigInteger>();
                for (i = 0; i < vectorInt.size(); ++i) {
                    nums.add(vectorInt.getBigInteger(i));
                }
                if (arg.equals(WasmParaType.VECTORINT8.getName())) {
                    wasmContractParameters.addInt8Array(nums);
                    continue;
                }
                if (arg.equals(WasmParaType.VECTORINT16.getName())) {
                    wasmContractParameters.addInt16Array(nums);
                    continue;
                }
                if (arg.equals(WasmParaType.VECTORINT32.getName())) {
                    wasmContractParameters.addInt32Array(nums);
                    continue;
                }
                if (arg.equals(WasmParaType.VECTORINT64.getName())) {
                    wasmContractParameters.addInt64Array(nums);
                    continue;
                }
                if (arg.equals(WasmParaType.VECTORUINT8.getName())) {
                    wasmContractParameters.addUint8Array(nums);
                    continue;
                }
                if (arg.equals(WasmParaType.VECTORUINT16.getName())) {
                    wasmContractParameters.addUint16Array(nums);
                    continue;
                }
                if (arg.equals(WasmParaType.VECTORUINT32.getName())) {
                    wasmContractParameters.addUint32Array(nums);
                    continue;
                }
                if (!arg.equals(WasmParaType.VECTORUINT64.getName())) continue;
                wasmContractParameters.addUint64Array(nums);
                continue;
            }
            if (arg.equals(WasmParaType.IDENTITY.getName())) {
                wasmContractParameters.addIdentity(new Hash(inputParamList.getString(index++)));
                continue;
            }
            if (arg.equals(WasmParaType.STRING.getName())) {
                wasmContractParameters.addString(inputParamList.getString(index++));
                continue;
            }
            if (arg.equals(WasmParaType.UINT8.getName())) {
                wasmContractParameters.addUInt8(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.UINT16.getName())) {
                wasmContractParameters.addUInt16(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.UINT32.getName())) {
                wasmContractParameters.addUInt32(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.UINT64.getName())) {
                wasmContractParameters.addUInt64(inputParamList.getBigInteger(index++));
                continue;
            }
            if (arg.equals(WasmParaType.BOOL.getName())) {
                wasmContractParameters.addBool(inputParamList.getBooleanValue(index++));
                continue;
            }
            if (arg.equals(WasmParaType.VECTORBOOL.getName())) {
                JSONArray vectorBool = inputParamList.getJSONArray(index++);
                LinkedList<Boolean> booleans = new LinkedList<Boolean>();
                for (i = 0; i < vectorBool.size(); ++i) {
                    booleans.add(vectorBool.getBoolean(i));
                }
                wasmContractParameters.addBooleanArray(booleans);
                continue;
            }
            if (!arg.equals(WasmParaType.VECTORSTRING.getName())) continue;
            JSONArray vectorString = inputParamList.getJSONArray(index++);
            LinkedList<String> strings = new LinkedList<String>();
            for (i = 0; i < vectorString.size(); ++i) {
                strings.add(vectorString.getString(i));
            }
            wasmContractParameters.addUtfStringArray(strings);
        }
    }

    public static List<Object> getWasmReturnValues(WASMOutput wasmContractReturnValues, String[] returnTypes) {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (String returnType : returnTypes) {
            if (returnType.endsWith(WasmParaType.INT8.getName())) {
                returnValues.add(wasmContractReturnValues.getInt64());
                continue;
            }
            if (returnType.equals(WasmParaType.INT16.getName())) {
                returnValues.add(wasmContractReturnValues.getInt16());
                continue;
            }
            if (returnType.equals(WasmParaType.INT32.getName())) {
                returnValues.add(wasmContractReturnValues.getInt32());
                continue;
            }
            if (returnType.equals(WasmParaType.INT64.getName())) {
                returnValues.add(wasmContractReturnValues.getInt64());
                continue;
            }
            if (returnType.equals(WasmParaType.UINT8.getName())) {
                returnValues.add(wasmContractReturnValues.getUint8());
                continue;
            }
            if (returnType.equals(WasmParaType.UINT16.getName())) {
                returnValues.add(wasmContractReturnValues.getUint16());
                continue;
            }
            if (returnType.equals(WasmParaType.UINT32.getName())) {
                returnValues.add(wasmContractReturnValues.getUint32());
                continue;
            }
            if (returnType.equals(WasmParaType.UINT64.getName())) {
                returnValues.add(wasmContractReturnValues.getUint64());
                continue;
            }
            if (returnType.equals(WasmParaType.STRING.getName())) {
                returnValues.add(wasmContractReturnValues.getString());
                continue;
            }
            if (returnType.equals(WasmParaType.VECTORSTRING.getName())) {
                returnValues.add(wasmContractReturnValues.getStringDynamicArray());
                continue;
            }
            if (returnType.equals(WasmParaType.VECTORINT8.getName()) || returnType.equals(WasmParaType.VECTORINT16.getName()) || returnType.equals(WasmParaType.VECTORINT32.getName()) || returnType.equals(WasmParaType.VECTORINT64.getName()) || returnType.equals(WasmParaType.VECTORUINT8.getName()) || returnType.equals(WasmParaType.VECTORUINT16.getName()) || returnType.equals(WasmParaType.VECTORUINT32.getName()) || returnType.equals(WasmParaType.VECTORUINT64.getName())) {
                if (returnType.equals(WasmParaType.VECTORINT8.getName())) {
                    returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Int8.class));
                    continue;
                }
                if (returnType.equals(WasmParaType.VECTORINT16.getName())) {
                    returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Int16.class));
                    continue;
                }
                if (returnType.equals(WasmParaType.VECTORINT32.getName())) {
                    returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Int32.class));
                    continue;
                }
                if (returnType.equals(WasmParaType.VECTORINT64.getName())) {
                    returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Int64.class));
                    continue;
                }
                if (returnType.equals(WasmParaType.VECTORUINT8.getName())) {
                    returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Uint8.class));
                    continue;
                }
                if (returnType.equals(WasmParaType.VECTORUINT16.getName())) {
                    returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Uint16.class));
                    continue;
                }
                if (returnType.equals(WasmParaType.VECTORUINT32.getName())) {
                    returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Uint32.class));
                    continue;
                }
                if (!returnType.equals(WasmParaType.VECTORUINT64.getName())) continue;
                returnValues.add(wasmContractReturnValues.getIntAndUintDynamicArray(Uint64.class));
                continue;
            }
            if (returnType.equals(WasmParaType.BOOL.getName())) {
                returnValues.add(wasmContractReturnValues.getBoolean());
                continue;
            }
            if (!returnType.equals(WasmParaType.VECTORBOOL.getName())) continue;
            returnValues.add(wasmContractReturnValues.getBooleanDynamicArray());
        }
        return returnValues;
    }

    public static void main(String[] args) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1));
        threadPoolExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("start");
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        threadPoolExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("start");
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        threadPoolExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    System.out.println("start");
                    Thread.sleep(3000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

