/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service;

import com.alipay.mychain.sdk.api.MychainClient;
import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.service.BaseService;
import com.alipay.mychain.sdk.api.service.spv.AbstractSpvProxy;
import com.alipay.mychain.sdk.api.service.spv.SpvImp;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.domain.contract.Contract;
import com.alipay.mychain.sdk.domain.spv.BlockHeaderInfo;
import com.alipay.mychain.sdk.domain.spv.ReceiptProof;
import com.alipay.mychain.sdk.domain.spv.TransactionProof;
import com.alipay.mychain.sdk.domain.spv.VerifiedBlock;
import com.alipay.mychain.sdk.domain.spv.WorldStateProof;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class SpvService
extends BaseService {
    SpvImp spvImp;

    public SpvService(INetwork network, TimerTaskManager timerTaskManager, ClientEnv env) {
        super(network, timerTaskManager, env);
    }

    @Override
    public boolean start(MychainClient client) {
        this.spvImp = new SpvImp(this.getEnv().getLogger(), client);
        return true;
    }

    @Override
    public boolean stop() {
        this.spvImp.stop();
        return true;
    }

    public boolean init(VerifiedBlock verifiedBlock, AbstractSpvProxy proxy, int maxBlockAmount, int intervalMs) {
        if (verifiedBlock == null || proxy == null || this.spvImp == null) {
            return false;
        }
        return this.spvImp.init(verifiedBlock, proxy, maxBlockAmount, intervalMs);
    }

    public void watchTopic(String topic) {
        if (StringUtils.isEmpty((CharSequence)topic) || this.spvImp == null) {
            return;
        }
        this.spvImp.watchTopic(topic);
    }

    public void watchIdentity(Hash id) {
        if (id == null || id.isEmpty() || this.spvImp == null) {
            return;
        }
        this.spvImp.watchIdentity(id);
    }

    public boolean verifyAccount(Account account, BigInteger blockNum) {
        return account.isValid() && this.spvImp != null && this.spvImp.verifyAccount(account, blockNum);
    }

    public boolean verifyContract(Contract contract, BigInteger blockNum) {
        return contract.isValid() && this.spvImp != null && this.spvImp.verifyContract(contract, blockNum);
    }

    public boolean verifyTransaction(Hash hash) {
        return hash != null && !hash.isEmpty() && this.spvImp != null && this.spvImp.verifyTransaction(hash);
    }

    public boolean verifyReceipt(Hash txHash, TransactionReceipt receipt) {
        return txHash != null && !txHash.isEmpty() && receipt != null && this.spvImp != null && this.spvImp.verifyReceipt(txHash, receipt);
    }

    public boolean verifyAccount(WorldStateProof proof, Account account, BigInteger blockNum) {
        return proof != null && account.isValid() && this.spvImp != null && blockNum.compareTo(BigInteger.ZERO) != -1 && this.spvImp.verifyAccount(proof, account, blockNum);
    }

    public boolean verifyContract(WorldStateProof proof, Contract contract, BigInteger blockNum) {
        return proof != null && contract.isValid() && this.spvImp != null && blockNum.compareTo(BigInteger.ZERO) != -1 && this.spvImp.verifyContract(proof, contract, blockNum);
    }

    public boolean verifyTransaction(TransactionProof proof, Hash txHash) {
        return proof != null && txHash != null && this.spvImp != null && this.spvImp.verifyTransaction(proof, txHash);
    }

    public boolean verifyReceipt(ReceiptProof proof, TransactionReceipt receipt) {
        return proof != null && receipt != null && this.spvImp != null && this.spvImp.verifyReceipt(proof, receipt);
    }

    public boolean verifyBlockHeader(VerifiedBlock block, BlockHeaderInfo info) {
        return block != null && info != null && this.spvImp != null && this.spvImp.verifyBlockHeader(block, info);
    }
}

