/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.hash;

import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.crypto.hash.IHash;
import com.alipay.mychain.sdk.crypto.hash.Keccak256;
import com.alipay.mychain.sdk.crypto.hash.SHA256Hash;
import com.alipay.mychain.sdk.crypto.hash.SM3Hash;

public class HashFactory {
    public static IHash getHash() {
        return new SHA256Hash();
    }

    public static IHash getHash(HashTypeEnum hashTypeEnum) {
        switch (hashTypeEnum) {
            case SHA256: {
                return new SHA256Hash();
            }
            case SM3: {
                return new SM3Hash();
            }
            case Keccak: {
                return new Keccak256();
            }
        }
        return new SHA256Hash();
    }
}

