/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.admin;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.status.LogLevel;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryLogLevelResponse
extends Response {
    private LogLevel logLevel;

    public QueryLogLevelResponse() {
        super(MessageType.MSG_TYPE_ADMIN_RESP_LOG_LEVEL);
    }

    public QueryLogLevelResponse(LogLevel logLevel) {
        super(MessageType.MSG_TYPE_ADMIN_RESP_LOG_LEVEL);
        this.logLevel = logLevel;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public byte[] toRlp() {
        byte[] logLevelBytes = Rlp.encodeInt(this.logLevel.getCode());
        return Rlp.encodeList(super.toRlp(), logLevelBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.logLevel = LogLevel.getLogLevelByCode(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("log_level", (Object)this.logLevel.getCode());
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.logLevel = LogLevel.getLogLevelByCode(jsonObject.getIntValue("log_level"));
    }
}

