/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.confidential;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.MyCrypto;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.keyoperator.KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.List;

public class ConfidentialRequest
extends AbstractTransactionRequest {
    private AbstractTransactionRequest request;
    private List<byte[]> publicKeys;
    private byte[] useKey;

    public ConfidentialRequest(AbstractTransactionRequest request, List<byte[]> publicKeys, byte[] useKey) {
        super(MessageType.MSG_TYPE_TX_REQ_CONFIDENTIAL_TX);
        this.request = request;
        this.publicKeys = publicKeys;
        this.useKey = useKey;
    }

    public ConfidentialRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_CONFIDENTIAL_TX);
    }

    public AbstractTransactionRequest getRequest() {
        return this.request;
    }

    public List<byte[]> getPublicKeys() {
        return this.publicKeys;
    }

    public void setPublicKeys(List<byte[]> publicKeys) {
        this.publicKeys = publicKeys;
    }

    public byte[] getUserKey() {
        return this.useKey;
    }

    @Override
    public boolean isValid() {
        if (this.request == null || !this.request.isValid()) {
            return false;
        }
        if (TransactionType.DEPLOY_CONTRACT.equals((Object)this.getRequest().getTransaction().getTxType()) || TransactionType.UPDATE_CONTRACT.equals((Object)this.getRequest().getTransaction().getTxType()) || TransactionType.CALL_CONTRACT.equals((Object)this.getRequest().getTransaction().getTxType())) {
            boolean result;
            boolean bl = result = this.request != null && this.request.isValid() && this.publicKeys != null && this.publicKeys.size() > 0 && this.useKey != null && this.useKey.length > 0;
            if (result) {
                KeyOperator keyOperator = MyCrypto.getInstance().getKeyOperator(KeyTypeEnum.KEY_ECCK1_PKCS8);
                Keypair keypair = keyOperator.loadFromPubkey(this.publicKeys.get(0));
                return keypair.getType() == KeyTypeEnum.KEY_ECCK1_PKCS8 || keypair.getType() == KeyTypeEnum.KEY_RSA2048_PKCS8;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void complete() {
        AlgoIdEnum algoId;
        if (this.request != null) {
            this.request.complete();
        }
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.TX_CONFIDENTIAL);
        transaction.setHash(this.request.getTransaction().getHash());
        transaction.setTimestamp(this.request.getTransaction().getTimestamp());
        transaction.setNonce(this.request.getTransaction().getNonce());
        if (this.publicKeys == null || this.publicKeys.size() <= 0) return;
        KeyOperator keyOperator = MyCrypto.getInstance().getKeyOperator(KeyTypeEnum.KEY_ECCK1_PKCS8);
        Keypair keypair = keyOperator.loadFromPubkey(this.publicKeys.get(0));
        if (keypair.getType() == KeyTypeEnum.KEY_ECCK1_PKCS8) {
            algoId = AlgoIdEnum.ENVELOPE_ECCK1_LOCAL_SGX;
        } else {
            if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) return;
            algoId = AlgoIdEnum.ENVELOPE_RSA_LOCAL_SGX;
        }
        EnvelopeBase envelopeBase = MyCrypto.getInstance().createEnvelopeByAlgo(algoId);
        ArrayList<Keypair> keyPairs = new ArrayList<Keypair>();
        for (byte[] publicKey : this.publicKeys) {
            Keypair keyPair = new Keypair(publicKey);
            keyPairs.add(keyPair);
        }
        envelopeBase.setPubkeyList(keyPairs);
        byte[] cipherText = envelopeBase.envelopeSeal(this.getRequest().getTransaction().toRlp(), this.useKey);
        transaction.setData(cipherText);
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        bytes.add(ByteUtils.hexStringToBytes("FF"));
        transaction.setSignatureList(bytes);
    }
}

