/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.envelope;

import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;

public abstract class GroupTransactionRequest
extends AbstractTransactionRequest {
    protected AbstractTransactionRequest request;

    public GroupTransactionRequest(MessageType type, AbstractTransactionRequest request, BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        super(type);
        this.request = request;
        this.groupId = groupId;
    }

    public GroupTransactionRequest(MessageType type) {
        super(type);
    }

    @Override
    public boolean isValid() {
        return this.getGroupId() != BaseFixedSizeByteArray.Fixed20ByteArray.defaultValue() && this.request != null && this.getRequest().isValid();
    }

    public AbstractTransactionRequest getRequest() {
        return this.request;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setGroupId(this.groupId);
        transaction.setData(this.request.getTransaction().toRlp());
        super.complete();
    }
}

