/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network;

import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.env.NetworkOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.codec.ICodec;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.MessageFactory;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.network.IConnection;
import com.alipay.mychain.sdk.network.IHandshakeCallback;
import com.alipay.mychain.sdk.network.IProcessor;
import com.alipay.mychain.sdk.network.MessageContext;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import com.alipay.mychain.sdk.utils.ExecutorUtils;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.util.CharsetUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MessageProcessor
implements IProcessor {
    private static final String MSG_PROCESSOR = "msgProcessor";
    private NetworkOption networkOption;
    private ILogger logger;
    private IConnection connection;
    private Lock lock = new ReentrantLock();
    private ICodec codec;
    private TimerTaskManager timerTaskManager = null;
    private ExecutorService msgProcessorExecutorService = null;
    private Map<MessageType, IEventCallback> msgCallbacks = new HashMap<MessageType, IEventCallback>();
    private IHandshakeCallback handshakeCallback = null;
    private Map<Long, MessageContext> msgContexts = new HashMap<Long, MessageContext>();

    public MessageProcessor(TimerTaskManager timerTaskManager, NetworkOption networkOption, ICodec codec, ILogger logger) {
        this.timerTaskManager = timerTaskManager;
        this.networkOption = networkOption;
        this.codec = codec;
        this.logger = logger;
    }

    public boolean start() {
        block4: {
            try {
                this.lock.lock();
                if (this.msgProcessorExecutorService == null) {
                    this.msgProcessorExecutorService = ExecutorUtils.getListeningExecutorService((int)this.networkOption.getCoreThreadPoolSize(), MSG_PROCESSOR, (int)this.networkOption.getThreadPoolQueueSize());
                    break block4;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
        return !this.msgProcessorExecutorService.isShutdown();
    }

    public boolean stop() {
        try {
            this.lock.lock();
            if (this.msgProcessorExecutorService != null && !this.msgProcessorExecutorService.isShutdown()) {
                this.msgProcessorExecutorService.shutdown();
            }
            this.msgCallbacks.clear();
            this.msgContexts.clear();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public boolean registerEventHandler(MessageType type, IEventCallback callback) {
        try {
            this.lock.lock();
            this.msgCallbacks.put(type, callback);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public boolean unRegisterEventHandler(MessageType type) {
        try {
            this.lock.lock();
            if (!this.msgCallbacks.containsKey((Object)type)) {
                boolean bl = false;
                return bl;
            }
            this.msgCallbacks.remove((Object)type);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveContext(MessageContext context) {
        if (context == null) {
            return false;
        }
        try {
            this.lock.lock();
            if (this.msgContexts.containsKey(context.getRequest().getSequenceId())) {
                this.logger.error("saveContext, the sequence is existed, seq: {}", (Object)context.getRequest().getSequenceId());
                boolean bl = false;
                return bl;
            }
            int size = this.msgContexts.size();
            if (size >= this.networkOption.getThreadPoolQueueSize()) {
                Response response = (Response)MessageFactory.getResponse(context.getRequest(), ErrorCode.SDK_MESSAGE_REACHED_MAX_QUEUE_SIZE);
                context.setResponse(response);
                this.logger.warn("saveContext, message is reached max queue size: {}", (Object)size);
                boolean bl = false;
                return bl;
            }
            this.msgContexts.put(context.getRequest().getSequenceId(), context);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageContext getContext(long sequence) {
        MessageContext msgContext;
        this.logger.debug("getContext, sequence: {}", (Object)sequence);
        try {
            this.lock.lock();
            if (!this.msgContexts.containsKey(sequence)) {
                this.logger.debug("getContext, msgContexts not contain sequence: {}", (Object)sequence);
                MessageContext messageContext = null;
                return messageContext;
            }
            msgContext = this.msgContexts.get(sequence);
            this.msgContexts.remove(sequence);
        }
        finally {
            this.lock.unlock();
        }
        return msgContext;
    }

    @Override
    public boolean pushMessage(final Object msg) {
        try {
            this.lock.lock();
            if (this.msgProcessorExecutorService == null || this.msgProcessorExecutorService.isShutdown()) {
                boolean bl = false;
                return bl;
            }
            this.msgProcessorExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    MessageProcessor.this.processMsg(msg);
                }
            });
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushTimeoutMessage(final long sequence, final Response response) {
        try {
            this.lock.lock();
            if (this.msgProcessorExecutorService == null || this.msgProcessorExecutorService.isShutdown()) {
                boolean bl = false;
                return bl;
            }
            this.msgProcessorExecutorService.submit(new Runnable(){

                @Override
                public void run() {
                    MessageProcessor.this.processTimeoutMsg(sequence, response);
                }
            });
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean processMsg(Object msg) {
        if (msg == null) {
            return true;
        }
        message = null;
        if (msg instanceof FullHttpResponse) {
            this.logger.debug("processMsg, debug http response. msg:{}", msg);
            httpResponse = (FullHttpResponse)msg;
            try {
                content = httpResponse.content();
                if (!content.isReadable()) ** GOTO lbl25
                contentLength = content.readableBytes();
                bytes = new byte[contentLength];
                content.readBytes(bytes);
                jsonString = new String(bytes, 0, contentLength, CharsetUtil.UTF_8);
                this.logger.debug("processMsg, jsonString:{}", (Object)jsonString);
                message = this.codec.decode(jsonString.getBytes());
            }
            finally {
                httpResponse.release();
            }
        } else if (msg instanceof byte[]) {
            this.logger.debug("processMsg, decode tcp response.");
            message = this.codec.decode((byte[])msg);
        }
lbl25:
        // 5 sources

        if (message == null) {
            this.logger.error("processMsg, decode failed.");
            return true;
        }
        this.logger.info("processMsg, message:{}", (Object)message.toString());
        if (this.handshakeCallback != null) {
            this.handshakeCallback.onResponse((Response)message);
            this.handshakeCallback = null;
            return true;
        }
        if (message.getMessageType() != null && this.msgCallbacks.containsKey((Object)message.getMessageType())) {
            this.msgCallbacks.get((Object)message.getMessageType()).onEvent(message);
            return true;
        }
        response = (Response)message;
        context = this.getContext(response.getSequenceId());
        if (context == null) {
            this.logger.debug("processMsg, msg context is null.");
            return true;
        }
        context.setResponse(response);
        this.timerTaskManager.unRegisterTask(context.getTaskId());
        if (this.connection == null) {
            return false;
        }
        this.connection.updateLastActiveTime();
        if (ErrorCode.SERVICE_CHAIN_OUT_OF_SERVICE == context.getResponse().getErrorCode()) {
            this.connection.disConnectForce();
        }
        this.logger.debug("processMsg, on response.");
        this.onResponse(context, ErrorCode.SUCCESS);
        return true;
    }

    public boolean processTimeoutMsg(long sequence, Response response) {
        MessageContext context = this.getContext(sequence);
        if (context == null) {
            this.logger.debug("processTimeoutMsg, msg context is null.");
            return true;
        }
        context.setResponse(response);
        this.logger.debug("processTimeoutMsg, on response.");
        this.onResponse(context, ErrorCode.SDK_TIMED_OUT);
        return true;
    }

    private void onResponse(MessageContext context, ErrorCode errorCode) {
        if (context.getRequestType() == MessageContext.RequestType.ASYNC_REQUEST) {
            context.getCallback().onResponse(errorCode.getErrorCode(), context.getResponse());
        } else {
            try {
                context.getLock().lock();
                context.getCondition().signalAll();
            }
            finally {
                context.getLock().unlock();
            }
        }
    }

    public void setNetworkConnection(IConnection connection) {
        this.connection = connection;
    }

    public void setHandshakeCallback(IHandshakeCallback callback) {
        this.handshakeCallback = callback;
    }
}

