/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty;

import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.TrustManagerFactory;

public class ClientSslContext {
    private static final String SSL_VER = "TLSv1.2";
    private static final SslProvider SSL_PROVIDER = SslProvider.OPENSSL;
    private ISslOption sslOption;
    private ILogger logger;

    public ClientSslContext(ISslOption sslOption, ILogger logger) {
        this.sslOption = sslOption;
        this.logger = logger;
    }

    public SslContext createSslContext() {
        try {
            TrustManagerFactory trustManagerFactory = this.createTrustManager(this.sslOption.getTrustStoreStream(), this.sslOption.getTrustStorePassword());
            if (trustManagerFactory != null) {
                SslContext sslContext = SslContextBuilder.forClient().sslProvider(SSL_PROVIDER).protocols(new String[]{SSL_VER}).keyManager(this.sslOption.getCertStream(), this.sslOption.getKeyStream(), this.sslOption.getKeyPassword()).trustManager(trustManagerFactory).build();
                return sslContext;
            }
        }
        catch (Exception e) {
            this.logger.error("Init SslContext exception:{}", (Object)e.getMessage());
        }
        return null;
    }

    private TrustManagerFactory createTrustManager(InputStream trustStoreStream, String trustStorePwd) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        KeyStore trustStore;
        TrustManagerFactory trustManagerFactory;
        if (trustStoreStream == null) {
            this.logger.error("trustStoreStream is null.");
            return null;
        }
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("createTrustManager is NoSuchAlgorithmException: {}", (Object)trustStorePwd);
            throw new NoSuchAlgorithmException("Not such algorithm exception.", e);
        }
        try {
            trustStore = trustStorePwd != null ? this.createKeyStore(trustStoreStream, trustStorePwd) : this.createKeyStore(trustStoreStream, null);
        }
        catch (IOException e) {
            this.logger.error("decode trustCa happens IOException with password: {}", (Object)trustStorePwd);
            throw new IOException("load custom key store happen IOException", e);
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("NoSuchAlgorithmException: {}", (Object)trustStorePwd);
            throw new NoSuchAlgorithmException("load custom key store happen NoSuchAlgorithmException", e);
        }
        catch (CertificateException e) {
            this.logger.error("CertificateException: {}", (Object)trustStorePwd);
            throw new CertificateException("load custom key store happen CertificateException", e);
        }
        catch (KeyStoreException e) {
            this.logger.error("load keystore failed: {}", (Object)trustStorePwd);
            throw new KeyStoreException("keystore load exception:", e);
        }
        try {
            trustManagerFactory.init(trustStore);
        }
        catch (KeyStoreException e) {
            this.logger.error("createTrustManager is KeyStoreException: {}", (Object)trustStorePwd);
            throw new KeyStoreException("trust manager init failed.", e);
        }
        return trustManagerFactory;
    }

    private KeyStore createKeyStore(InputStream trustStoreStream, String trustStorePwd) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore trustStore = null;
        trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        if (trustStorePwd != null) {
            trustStore.load(trustStoreStream, trustStorePwd.toCharArray());
        } else {
            trustStore.load(trustStoreStream, null);
        }
        return trustStore;
    }
}

