/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.task;

import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import com.alipay.mychain.sdk.utils.ExecutorUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class TimerTaskManager {
    private Long currentTaskId = 0L;
    private Map<Long, AbstractTask> taskMap = new ConcurrentHashMap<Long, AbstractTask>();
    private ScheduledExecutorService executor = ExecutorUtils.getScheduledExecutorService("TimerTaskManager");

    public void startTimerTask() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimerTaskManager.this.processTask();
            }
        }, 10L, 100L, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.clearTask();
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTask() {
        ConcurrentHashMap<Long, AbstractTask> tasks;
        TimerTaskManager timerTaskManager = this;
        synchronized (timerTaskManager) {
            tasks = new ConcurrentHashMap<Long, AbstractTask>(this.taskMap);
        }
        for (Map.Entry entry : tasks.entrySet()) {
            Long taskId = (Long)entry.getKey();
            if (!this.isExist(taskId)) continue;
            AbstractTask task = (AbstractTask)entry.getValue();
            if (System.currentTimeMillis() <= task.getNextTime()) continue;
            task.setNextTime(task.getNextTime() + (long)task.getInterval().intValue());
            task.run();
            if (!task.getType().equals((Object)TaskType.ONCE)) continue;
            this.unRegisterTask(taskId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long registerTask(AbstractTask task) {
        Long taskId;
        if (task == null) {
            return 0L;
        }
        TimerTaskManager timerTaskManager = this;
        synchronized (timerTaskManager) {
            TimerTaskManager timerTaskManager2 = this;
            Long l = timerTaskManager2.currentTaskId;
            Long l2 = timerTaskManager2.currentTaskId = Long.valueOf(timerTaskManager2.currentTaskId + 1L);
            taskId = l;
        }
        this.taskMap.put(taskId, task);
        return taskId;
    }

    public void unRegisterTask(long taskId) {
        this.taskMap.remove(taskId);
    }

    private boolean isExist(Long taskId) {
        return this.taskMap.containsKey(taskId);
    }

    private void clearTask() {
        this.taskMap.clear();
    }
}

