/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi;

import com.alipay.mychain.sdk.vm.abi.datatype.AbstractArray;
import com.alipay.mychain.sdk.vm.abi.datatype.AbstractNumericType;
import com.alipay.mychain.sdk.vm.abi.datatype.Bool;
import com.alipay.mychain.sdk.vm.abi.datatype.Bytes;
import com.alipay.mychain.sdk.vm.abi.datatype.BytesType;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicArray;
import com.alipay.mychain.sdk.vm.abi.datatype.DynamicBytes;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.abi.datatype.Ufixed;
import com.alipay.mychain.sdk.vm.abi.datatype.Uint;
import com.alipay.mychain.sdk.vm.abi.datatype.Utf8String;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class MyTypeEncoder {
    private MyTypeEncoder() {
    }

    static boolean isDynamic(Type parameter) {
        return parameter instanceof DynamicBytes || parameter instanceof Utf8String || parameter instanceof DynamicArray;
    }

    public static String encode(Type parameter) {
        if (parameter instanceof AbstractNumericType) {
            return MyTypeEncoder.encodeNumeric((AbstractNumericType)parameter);
        }
        if (parameter instanceof Bool) {
            return MyTypeEncoder.encodeBool((Bool)parameter);
        }
        if (parameter instanceof Bytes) {
            return MyTypeEncoder.encodeBytes((Bytes)parameter);
        }
        if (parameter instanceof DynamicBytes) {
            return MyTypeEncoder.encodeDynamicBytes((DynamicBytes)parameter);
        }
        if (parameter instanceof Utf8String) {
            return MyTypeEncoder.encodeString((Utf8String)parameter);
        }
        if (parameter instanceof DynamicArray) {
            return MyTypeEncoder.encodeDynamicArray((DynamicArray)parameter);
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + parameter.getClass());
    }

    static String encodeNumeric(AbstractNumericType numericType) {
        byte[] rawValue = MyTypeEncoder.toByteArray(numericType);
        byte paddingValue = MyTypeEncoder.getPaddingValue(numericType);
        byte[] paddedRawValue = new byte[32];
        if (paddingValue != 0) {
            for (int i = 0; i < paddedRawValue.length; ++i) {
                paddedRawValue[i] = paddingValue;
            }
        }
        System.arraycopy(rawValue, 0, paddedRawValue, 32 - rawValue.length, rawValue.length);
        return Numeric.toHexStringNoPrefix(paddedRawValue);
    }

    private static byte getPaddingValue(AbstractNumericType numericType) {
        if (numericType.getValue().signum() == -1) {
            return -1;
        }
        return 0;
    }

    private static byte[] toByteArray(AbstractNumericType numericType) {
        BigInteger value = numericType.getValue();
        if ((numericType instanceof Ufixed || numericType instanceof Uint) && value.bitLength() == 256) {
            byte[] byteArray = new byte[32];
            System.arraycopy(value.toByteArray(), 1, byteArray, 0, 32);
            return byteArray;
        }
        return value.toByteArray();
    }

    static String encodeBool(Bool value) {
        byte[] rawValue = new byte[32];
        if (value.getValue().booleanValue()) {
            rawValue[rawValue.length - 1] = 1;
        }
        return Numeric.toHexStringNoPrefix(rawValue);
    }

    static String encodeBytes(BytesType bytesType) {
        byte[] dest;
        byte[] value = bytesType.getValue();
        int length = value.length;
        int mod = length % 32;
        if (mod != 0) {
            int padding = 32 - mod;
            dest = new byte[length + padding];
            System.arraycopy(value, 0, dest, 0, length);
        } else {
            dest = value;
        }
        return Numeric.toHexStringNoPrefix(dest);
    }

    static String encodeDynamicBytes(DynamicBytes dynamicBytes) {
        int size = dynamicBytes.getValue().length;
        String encodedLength = MyTypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValue = MyTypeEncoder.encodeBytes(dynamicBytes);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValue);
        return result.toString();
    }

    static String encodeString(Utf8String string) {
        byte[] utfEncoded = string.getValue().getBytes(StandardCharsets.UTF_8);
        return MyTypeEncoder.encodeDynamicBytes(new DynamicBytes(utfEncoded));
    }

    static <T extends Type> String encodeArrayValues(AbstractArray<T> value) {
        StringBuilder result = new StringBuilder();
        Iterator iterator = value.getValue().iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            result.append(MyTypeEncoder.encode(type));
        }
        return result.toString();
    }

    static <T extends Type> String encodeDynamicArray(DynamicArray<T> value) {
        int size = value.getValue().size();
        String encodedLength = MyTypeEncoder.encode(new Uint(BigInteger.valueOf(size)));
        String encodedValues = MyTypeEncoder.encodeArrayValues(value);
        StringBuilder result = new StringBuilder();
        result.append(encodedLength);
        result.append(encodedValues);
        return result.toString();
    }
}

