/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.abi.datatype;

import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import java.math.BigInteger;

public abstract class AbstractNumericType
implements Type<BigInteger> {
    private String type;
    private BigInteger value;
    private int byteLength;

    public AbstractNumericType(String type, BigInteger value, int bitLength) {
        this.type = type;
        this.value = value;
        this.byteLength = bitLength / 8;
    }

    @Override
    public String getTypeAsString() {
        return this.type;
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractNumericType that = (AbstractNumericType)o;
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

