/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.annotation.privacy;

import com.alipay.mychain.zoro.annotation.privacy.Note;
import com.alipay.mychain.zoro.crypto.BulletProof;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.exception.ZoroException;
import com.alipay.mychain.zoro.util.Base64Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitmentChecker {
    private static final Logger logger = LoggerFactory.getLogger(CommitmentChecker.class);

    public static Note checkCommitment(String commitment, String plainValue, String plainBlindFactor, String encryptedValue, String encryptedBlindFactor) {
        long value = Long.parseLong(plainValue);
        byte[] blindFactor = Base64Codec.decode(plainBlindFactor);
        byte[] commit = Base64Codec.decode(commitment);
        boolean ok = false;
        try {
            ok = BulletProof.verifyCommit(commit, blindFactor, value);
        }
        catch (CryptoException ex) {
            logger.error("Failed to check commitment: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_NOT_MATCHED, ex.toString());
        }
        if (!ok) {
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_NOT_MATCHED, "Commitment is not matched with blind factor and value");
        }
        Note note = new Note();
        note.setBlindFactor(Base64Codec.encode(blindFactor));
        note.setEncryptedBlindFactor(encryptedBlindFactor);
        note.setValue(value);
        note.setEncryptedValue(encryptedValue);
        note.setPedersenCommitment(commitment);
        return note;
    }
}

