/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.annotation.privacy;

import com.alipay.mychain.zoro.annotation.ApplyEnvelope;
import com.alipay.mychain.zoro.annotation.privacy.Node;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.envelop.EnvelopeEnc;
import com.alipay.mychain.zoro.exception.ZoroException;
import com.alipay.mychain.zoro.util.Base64Codec;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Decryptor {
    private static final Logger logger = LoggerFactory.getLogger(Decryptor.class);

    public static String decrypt(String ciphtetext, String envelop, byte[] keyName, byte[] password) {
        Vector<byte[]> ciphertextVec = new Vector<byte[]>();
        ciphertextVec.add(Base64Codec.decode(ciphtetext));
        Vector<byte[]> plaintextVec = null;
        try {
            plaintextVec = EnvelopeEnc.decrypt(keyName, password, Base64Codec.decode(envelop), ciphertextVec);
        }
        catch (Exception ex) {
            logger.error("Failed to decrypt: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.ENVELOPE_DECRYPT_FAILED, ex.getMessage());
        }
        return new String(plaintextVec.get(0), StandardCharsets.UTF_8);
    }

    public static List<String> decrypt(List<String> ciphertextList, String envelop, byte[] keyName, byte[] password) {
        Vector<byte[]> ciphertextVec = new Vector<byte[]>();
        for (String ciphertext : ciphertextList) {
            ciphertextVec.add(Base64Codec.decode(ciphertext));
        }
        Vector<byte[]> plaintextVec = null;
        try {
            plaintextVec = EnvelopeEnc.decrypt(keyName, password, Base64Codec.decode(envelop), ciphertextVec);
        }
        catch (Exception ex) {
            logger.error("Failed to decrypt: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.ENVELOPE_DECRYPT_FAILED, ex.getMessage());
        }
        ArrayList<String> plaintextList = new ArrayList<String>();
        for (byte[] plaintext : plaintextVec) {
            plaintextList.add(new String(plaintext, StandardCharsets.UTF_8));
        }
        return plaintextList;
    }

    public static void decrypt(Node rootOfObjectTree, String selfId, byte[] keyName, byte[] password) {
        HashMap<String, String> attrToValue = new HashMap<String, String>(32);
        HashMap<String, List<String>> envelopPkToAttrList = new HashMap<String, List<String>>(32);
        HashMap<String, String> envelopToEnvelop = new HashMap<String, String>(32);
        Decryptor.collectCiphertextsFromTree((Map)rootOfObjectTree.getData(), attrToValue, envelopPkToAttrList, envelopToEnvelop, selfId);
        Decryptor.checkAttrVisibility(attrToValue, envelopPkToAttrList, envelopToEnvelop);
        Map<String, String> result = Decryptor.dectypt(keyName, password, attrToValue, envelopPkToAttrList, envelopToEnvelop);
        Decryptor.writePlaintextsToTree((Map)rootOfObjectTree.getData(), result);
    }

    private static void checkAttrVisibility(Map<String, String> attrToValue, Map<String, List<String>> envelopPkToAttrList, Map<String, String> envelopToEnvelop) {
        Iterator<Map.Entry<String, List<String>>> it = envelopPkToAttrList.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> entry = it.next();
            if (envelopToEnvelop.containsKey(entry.getKey())) continue;
            for (String attr : entry.getValue()) {
                attrToValue.remove(attr);
            }
            it.remove();
        }
    }

    private static void collectCiphertextsFromTree(Map<String, Node> root, Map<String, String> attrToValue, Map<String, List<String>> envelopPkToAttrList, Map<String, String> envelopToEnvelop, String selfId) {
        block0: for (Node value : root.values()) {
            if (value.isLeaf()) {
                Annotation[] annotations = value.getFieldAnnotations();
                if (annotations == null || annotations.length == 0) continue;
                String applyEnvelopeValue = null;
                for (Annotation a : annotations) {
                    if (!(a instanceof ApplyEnvelope)) continue;
                    applyEnvelopeValue = ((ApplyEnvelope)a).value();
                    if (!attrToValue.containsKey(value.getConcreteName())) {
                        if (value.getData() == null) {
                            logger.error("The value of decrypted attr should not be NULL.");
                            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "The value of decrypted attr should not be NULL");
                        }
                        attrToValue.put(value.getConcreteName(), (String)value.getData());
                    }
                    if (!envelopPkToAttrList.containsKey(applyEnvelopeValue)) {
                        ArrayList attrList = new ArrayList();
                        envelopPkToAttrList.put(applyEnvelopeValue, attrList);
                    }
                    envelopPkToAttrList.get(applyEnvelopeValue).add(value.getConcreteName());
                    continue block0;
                }
                continue;
            }
            if (value.getType() == List.class) {
                for (Object elementOfList : (List)value.getData()) {
                    Decryptor.collectCiphertextsFromTree((Map)((Node)elementOfList).getData(), attrToValue, envelopPkToAttrList, envelopToEnvelop, selfId);
                }
                continue;
            }
            if (value.getType() != Map.class) continue;
            Decryptor.collectCiphertextsFromTree((Map)value.getData(), attrToValue, envelopPkToAttrList, envelopToEnvelop, selfId);
        }
        Decryptor.collectEnvelopFromTree(root, envelopPkToAttrList, envelopToEnvelop, selfId);
    }

    private static void collectEnvelopFromTree(Map<String, Node> root, Map<String, List<String>> envelopPkToAttrList, Map<String, String> envelopToEnvelop, String selfId) {
        for (String key : envelopPkToAttrList.keySet()) {
            Map envelopMap;
            if (!root.containsKey(key) || envelopToEnvelop.containsKey(key) || !(envelopMap = (Map)root.get(key).getData()).containsKey(selfId)) continue;
            envelopToEnvelop.put(key, (String)envelopMap.get(selfId));
        }
        for (Node value : root.values()) {
            if (value.isLeaf()) continue;
            if (value.getType() == Map.class) {
                Decryptor.collectEnvelopFromTree((Map)value.getData(), envelopPkToAttrList, envelopToEnvelop, selfId);
                continue;
            }
            if (value.getType() != List.class) continue;
            for (Object elementOfList : (List)value.getData()) {
                Decryptor.collectEnvelopFromTree((Map)((Node)elementOfList).getData(), envelopPkToAttrList, envelopToEnvelop, selfId);
            }
        }
    }

    private static Map<String, String> dectypt(byte[] keyName, byte[] password, Map<String, String> attrToValue, Map<String, List<String>> envelopPkToAttrList, Map<String, String> envelopToEnvelop) {
        HashMap<String, String> result = new HashMap<String, String>(attrToValue);
        for (Map.Entry<String, List<String>> entry : envelopPkToAttrList.entrySet()) {
            String envelopKey = entry.getKey();
            List<String> attrLIst = entry.getValue();
            HashMap<String, String> ciphertextsMap = new HashMap<String, String>(32);
            for (String attr : attrLIst) {
                ciphertextsMap.put(attr, attrToValue.get(attr));
            }
            if (!envelopToEnvelop.containsKey(envelopKey)) {
                logger.error("The envelop is not correct.");
                throw new ZoroException(ZoroErrorCodeEnum.ANNOTATION_ASSIGNED_VALUE_NOT_CORRECT, "The envelop is not correct.");
            }
            String envelop = envelopToEnvelop.get(envelopKey);
            Map<String, String> plaintextMap = Decryptor.decrypt(keyName, password, envelop, ciphertextsMap);
            for (Map.Entry<String, String> attrToPlaintext : plaintextMap.entrySet()) {
                result.put(attrToPlaintext.getKey(), attrToPlaintext.getValue());
            }
        }
        return result;
    }

    private static void writePlaintextsToTree(Map<String, Node> root, Map<String, String> attrToValue) {
        for (Node value : root.values()) {
            if (value.isLeaf()) {
                if (!attrToValue.containsKey(value.getConcreteName())) continue;
                value.setData(attrToValue.get(value.getConcreteName()));
                continue;
            }
            if (value.getType() == List.class) {
                for (Object o : (List)value.getData()) {
                    Decryptor.writePlaintextsToTree((Map)((Node)o).getData(), attrToValue);
                }
                continue;
            }
            if (value.getType() != Map.class) continue;
            Decryptor.writePlaintextsToTree((Map)value.getData(), attrToValue);
        }
    }

    private static Map<String, String> decrypt(byte[] keyName, byte[] password, String envelopeKeyEncMsg, HashMap<String, String> ciphertextsMap) {
        Vector<byte[]> plaintexts;
        Vector<byte[]> ciphertextsVec = new Vector<byte[]>();
        for (String key : ciphertextsMap.keySet()) {
            ciphertextsVec.add(Base64Codec.decode(ciphertextsMap.get(key)));
        }
        try {
            plaintexts = EnvelopeEnc.decrypt(keyName, password, Base64Codec.decode(envelopeKeyEncMsg), ciphertextsVec);
        }
        catch (Exception ex) {
            logger.error("Failed to decrypt: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.ENVELOPE_DECRYPT_FAILED, ex.getMessage());
        }
        int index = 0;
        HashMap<String, String> plaintextMap = new HashMap<String, String>(32);
        for (String key : ciphertextsMap.keySet()) {
            plaintextMap.put(key, new String(plaintexts.get(index), StandardCharsets.UTF_8));
            ++index;
        }
        return plaintextMap;
    }
}

