/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.annotation.privacy;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.zoro.annotation.privacy.Node;
import com.alipay.mychain.zoro.annotation.privacy.ZoroType;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.exception.ZoroException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Writer {
    private static final Logger logger = LoggerFactory.getLogger(Writer.class);

    public static String writeAsString(Node rootOfObjectTree) {
        JSONObject jsonObject = new JSONObject();
        Writer.writeAsJSONObject((Map)rootOfObjectTree.getData(), jsonObject);
        return jsonObject.toJSONString();
    }

    private static void writeAsJSONObject(Map<String, Node> rootMap, JSONObject jsonObject) {
        if (null == rootMap || null == jsonObject) {
            logger.error("Parameter (rootMap or jsonObject) is NULL.");
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        for (Map.Entry<String, Node> entry : rootMap.entrySet()) {
            String key = entry.getKey();
            Node value = entry.getValue();
            if (value.isLeaf()) {
                jsonObject.put(key, value.getData());
                continue;
            }
            if (value.getType() == ZoroType.LIST) {
                JSONArray jsonArray = new JSONArray();
                jsonObject.put(key, (Object)jsonArray);
                for (Object element : (List)value.getData()) {
                    JSONObject innerJSONObject = new JSONObject();
                    jsonArray.add((Object)innerJSONObject);
                    Writer.writeAsJSONObject((Map)((Node)element).getData(), innerJSONObject);
                }
                continue;
            }
            if (value.getType() != ZoroType.MAP) continue;
            JSONObject innerJSONObject = new JSONObject();
            jsonObject.put(key, (Object)innerJSONObject);
            Writer.writeAsJSONObject((Map)value.getData(), innerJSONObject);
        }
    }

    public static <T> T writeAsDesignatedObjectIndirectly(Node rootOfObjectTree, Class<T> clazz) {
        String resultInJSONStr = Writer.writeAsString(rootOfObjectTree);
        Object result = JSONObject.parseObject((String)resultInJSONStr, clazz);
        return (T)result;
    }

    public static <T> T writeAsDesignatedObject(Node rootOfObjectTree, Class<T> clazz) {
        T result = null;
        try {
            result = clazz.newInstance();
        }
        catch (Exception ex) {
            logger.error("Failed to create object by reflection: {}", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, "Failed to create object by reflection");
        }
        Writer.writeAsDesignatedObject((Map)rootOfObjectTree.getData(), result, clazz);
        return result;
    }

    private static void writeAsDesignatedObject(Map<String, Node> rootMap, Object obj, Class<?> clazz) {
        Field[] fields;
        if (null == rootMap || null == obj || clazz == null) {
            logger.error("Parameter is NULL.");
            throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Parameter cannot be NULL");
        }
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (f.isSynthetic()) continue;
            f.setAccessible(true);
            String fieldName = f.getName();
            Class<?> fieldType = f.getType();
            if (!rootMap.containsKey(fieldName)) {
                throw new ZoroException(ZoroErrorCodeEnum.TARGET_ATTRIBUTE_NOT_EXIST, "Target attribute not exist.");
            }
            Node node = rootMap.get(fieldName);
            if (fieldType == ZoroType.STRING) {
                if (node.getType() != fieldType) {
                    throw new ZoroException(ZoroErrorCodeEnum.TARGET_ATTRIBUTE_TYPE_NOT_MATCHED, "Target attribute type not matched.");
                }
                try {
                    f.set(obj, node.getData());
                    continue;
                }
                catch (IllegalAccessException ex) {
                    logger.error("Illegal access exception: {}", (Throwable)ex);
                    throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                }
            }
            if (fieldType == ZoroType.LIST) {
                if (node.getType() != fieldType) {
                    throw new ZoroException(ZoroErrorCodeEnum.TARGET_ATTRIBUTE_TYPE_NOT_MATCHED, "Target attribute type not matched.");
                }
                AbstractList tempList = null;
                if (List.class.isAssignableFrom(ArrayList.class)) {
                    tempList = new ArrayList();
                } else if (List.class.isAssignableFrom(LinkedList.class)) {
                    tempList = new LinkedList();
                }
                try {
                    f.set(obj, tempList);
                }
                catch (IllegalAccessException ex) {
                    logger.error("Illegal access exception: {}", (Throwable)ex);
                    throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                }
                Type type = f.getGenericType();
                Type[] argumentsType = ((ParameterizedType)type).getActualTypeArguments();
                for (Object elementOfList : (List)node.getData()) {
                    Object targetObj = null;
                    try {
                        targetObj = Class.forName(((Class)argumentsType[0]).getName()).newInstance();
                    }
                    catch (ClassNotFoundException ex) {
                        logger.error("Class not found exception: {}", (Throwable)ex);
                        throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                    }
                    catch (IllegalAccessException ex) {
                        logger.error("Illegal access exception: {}", (Throwable)ex);
                        throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                    }
                    catch (InstantiationException ex) {
                        logger.error("Instantiation exception: {}", (Throwable)ex);
                        throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                    }
                    tempList.add(targetObj);
                    Writer.writeAsDesignatedObject((Map)((Node)elementOfList).getData(), targetObj, targetObj.getClass());
                }
                continue;
            }
            if (fieldType == ZoroType.PRIMITIVE_LONG) {
                if (node.getType() != fieldType) {
                    throw new ZoroException(ZoroErrorCodeEnum.TARGET_ATTRIBUTE_TYPE_NOT_MATCHED, "Target attribute type not matched.");
                }
                try {
                    f.setLong(obj, (Long)node.getData());
                    continue;
                }
                catch (IllegalAccessException ex) {
                    logger.error("Illegal access exception: {}", (Throwable)ex);
                    throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                }
            }
            if (fieldType == ZoroType.LONG) {
                if (node.getType() != fieldType) {
                    throw new ZoroException(ZoroErrorCodeEnum.TARGET_ATTRIBUTE_TYPE_NOT_MATCHED, "Target attribute type not matched.");
                }
                try {
                    f.set(obj, node.getData());
                    continue;
                }
                catch (IllegalAccessException ex) {
                    logger.error("Illegal access exception: {}", (Throwable)ex);
                    throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                }
            }
            if (fieldType == ZoroType.MAP) {
                try {
                    f.set(obj, node.getData());
                    continue;
                }
                catch (IllegalAccessException ex) {
                    logger.error("Illegal access exception: {}", (Throwable)ex);
                    throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
                }
            }
            try {
                Object tempObj = fieldType.newInstance();
                f.set(obj, tempObj);
                if (node.getType() != ZoroType.MAP) {
                    throw new ZoroException(ZoroErrorCodeEnum.TARGET_ATTRIBUTE_TYPE_NOT_MATCHED, "Target attribute type not matched.");
                }
                Writer.writeAsDesignatedObject((Map)node.getData(), tempObj, tempObj.getClass());
            }
            catch (InstantiationException ex) {
                logger.error("Instantiation exception: {}", (Throwable)ex);
                throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
            }
            catch (IllegalAccessException ex) {
                logger.error("Illegal access exception: {}", (Throwable)ex);
                throw new ZoroException(ZoroErrorCodeEnum.REFLECT_OPERATION_EXCEPTION, ex.toString());
            }
        }
    }
}

