/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.core.fault;

import com.ejtone.mars.kernel.core.fault.Fault;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class Err
implements Serializable {
    private static final long serialVersionUID = 3297738073315263402L;
    public static final Err IllegalMsgfmt = new Err("IllegalMsgfmt");
    public static final Err InternalError = new Err("InternalError");
    public static final Err SystemBusy = new Err("SystemBusy");
    public static final Err IllegalState = new Err("IllegalState");
    public static final Err InvalidMessage = new Err("InvalidMessage");
    public static final Err InvalidUsrOrPwd = new Err("InvalidUsrOrPwd");
    public static final Err IllegalIpAddress = new Err("IllegalIpAddress");
    public static final Err RequestTimeout = new Err("RequestTimeout");
    public static final Err TransportError = new Err("TransportError");
    public static final Err QueueOverLimit = new Err("QueueOverLimit");
    public static final Err FlowOverLimit = new Err("FlowOverLimit");
    public static final Err IllegalProtocol = new Err("IllegalProtocol");
    public static final Err IllegalUseTemplate = new Err("IllegalUseTemplate");
    public static final Err OverDailyMax = new Err("OverDailyMax");
    public static final Err NotLoadedSign = new Err("NotLoadedSign");
    public static final Err FastChNotFound = new Err("FastChNotFound");
    public static final Err NotFindMimeData = new Err("NotFindMimeData");
    public static final Err InvalidMmsContent = new Err("InvalidMmsContent");
    public static final Err RequestTooOften = new Err("RequestTooOften");
    private String reason;
    private String msg;

    public Err(String reason) {
        this(reason, null);
    }

    public Err(String reason, String msg) {
        this.reason = reason;
        this.msg = msg;
    }

    public String getReason() {
        return this.reason;
    }

    public String getMsg() {
        return this.msg;
    }

    public Err newInstance(String msg) {
        return new Err(this.reason, msg);
    }

    public Fault makeFault() {
        return new Fault(this);
    }

    public Fault makeFault(String message) {
        return new Fault(this.newInstance(message));
    }

    public Fault makeFault(Throwable cause) {
        if (StringUtils.isBlank(this.msg) && !StringUtils.isBlank(cause.getMessage())) {
            return new Fault(this.newInstance(cause.getMessage()), cause);
        }
        return new Fault(this, cause);
    }

    public boolean becauseOf(String ... reasons) {
        for (String c : reasons) {
            if (!this.reason.equals(c)) continue;
            return true;
        }
        return false;
    }

    public boolean becauseOf(Err ... reasons) {
        for (Err c : reasons) {
            if (!this.reason.equals(c.getReason())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (StringUtils.isBlank(this.msg)) {
            return this.reason;
        }
        return this.reason + ":" + this.msg;
    }
}

