/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.core.msgq;

import com.ejtone.mars.kernel.core.fault.Fault;
import com.ejtone.mars.kernel.core.message.Message;
import com.ejtone.mars.kernel.core.msgq.MsgListener;
import com.ejtone.mars.kernel.core.msgq.MsgQService;
import org.apache.rocketmq.client.producer.DefaultMQProducer;

public final class DelegateMsgQService
implements MsgQService {
    private MsgQService delegate;

    public static DelegateMsgQService getInstance() {
        return InstanceHolder.instance;
    }

    private DelegateMsgQService() {
    }

    public MsgQService getDelegate() {
        return this.delegate;
    }

    @Override
    public void send(String name, String tag, String key, Message message) throws Fault {
        this.delegate.send(name, tag, key, message);
    }

    @Override
    public void send(String name, String tag, String key, Message message, int delayLevel) throws Fault {
        this.delegate.send(name, tag, key, message, delayLevel);
    }

    @Override
    public void subscribe(String group, String name, String tag) {
        this.delegate.subscribe(group, name, tag);
    }

    @Override
    public void subscribe(String group, String name, String tag, MsgListener listener) {
        this.delegate.subscribe(group, name, tag, listener);
    }

    @Override
    public void unsubscribe(String group, String name, String tag) {
        this.delegate.unsubscribe(group, name, tag);
    }

    @Override
    public void setDefaultMsgListener(MsgListener listener) {
        this.delegate.setDefaultMsgListener(listener);
    }

    public void setDelegate(MsgQService delegate) {
        this.delegate = delegate;
    }

    @Override
    public void suspend(String group, String name, String tag) {
        this.delegate.suspend(group, name, tag);
    }

    @Override
    public void resume(String group, String name, String tag) {
        this.delegate.resume(group, name, tag);
    }

    @Override
    public DefaultMQProducer getProducer() {
        return this.delegate.getProducer();
    }

    private static final class InstanceHolder {
        public static final DelegateMsgQService instance = new DelegateMsgQService();

        private InstanceHolder() {
        }
    }
}

