/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.core.msgq;

import com.ejtone.mars.kernel.core.message.Message;
import com.ejtone.mars.kernel.core.msgq.MsgSerializer;
import com.ejtone.mars.kernel.util.CharsetUtil;
import com.ejtone.mars.kernel.util.JsonUtil;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMsgSerializer
implements MsgSerializer {
    private static final Logger logger = LoggerFactory.getLogger(JsonMsgSerializer.class);

    @Override
    public byte[] serialize(Message msg) {
        byte[] json = CharsetUtil.getBytesUtf8(JsonUtil.toJsonString(msg));
        byte[] clazz = CharsetUtil.getBytesUtf8(msg.getClass().getName());
        int length = 8 + clazz.length + json.length;
        ByteBuffer b = ByteBuffer.allocate(length);
        b.putInt(clazz.length);
        b.put(clazz);
        b.putInt(json.length);
        b.put(json);
        return b.array();
    }

    @Override
    public Message deserialize(byte[] data) {
        ByteBuffer b = ByteBuffer.wrap(data);
        try {
            if (data.length <= 8) {
                return null;
            }
            int len = b.getInt();
            byte[] clazz = new byte[len];
            b.get(clazz);
            len = b.getInt();
            byte[] json = new byte[len];
            b.get(json);
            String clazzName = CharsetUtil.newStringUtf8(clazz);
            String jsonText = CharsetUtil.newStringUtf8(json);
            return (Message)JsonUtil.fromJsonString(jsonText, Class.forName(clazzName));
        }
        catch (Throwable t) {
            logger.error("", (Object)t.getMessage());
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

