/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.core.sender;

import com.ejtone.mars.kernel.core.sender.Sender;
import com.ejtone.mars.kernel.core.sender.SenderService;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSenderService
implements SenderService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSenderService.class);
    private Map<String, Sender> map = new ConcurrentHashMap<String, Sender>();
    private int stopTimeout = 5000;

    @Override
    public Sender getSender(String name) {
        return this.map.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void regist(Sender sender) {
        DefaultSenderService defaultSenderService = this;
        synchronized (defaultSenderService) {
            logger.info("regist sender {}", (Object)sender.getName());
            this.map.put(sender.getName(), sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregist(Sender sender) {
        DefaultSenderService defaultSenderService = this;
        synchronized (defaultSenderService) {
            logger.info("unregist sender {}", (Object)sender.getName());
            this.map.remove(sender.getName());
        }
    }

    public int getStopTimeout() {
        return this.stopTimeout;
    }

    public void setStopTimeout(int stopTimeout) {
        this.stopTimeout = stopTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.map.size() != 0) {
            ArrayList<Sender> list;
            DefaultSenderService defaultSenderService = this;
            synchronized (defaultSenderService) {
                list = new ArrayList<Sender>(this.map.values());
            }
            ThreadPoolExecutor executor = new ThreadPoolExecutor(list.size(), list.size(), 1800L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(list.size()));
            for (Sender sender : list) {
                executor.execute(new SenderStopTask(sender));
            }
            executor.shutdown();
            try {
                executor.awaitTermination(this.stopTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!executor.isTerminated()) {
                executor.shutdownNow();
            }
        }
    }

    private static final class SenderStopTask
    implements Runnable {
        private Sender sender;

        public SenderStopTask(Sender sender) {
            this.sender = sender;
        }

        @Override
        public void run() {
            try {
                this.sender.stop();
            }
            catch (Exception e) {
                logger.error("shutdown sender {} exception", (Object)this.sender.getName());
            }
        }
    }
}

