/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.core.sender;

import com.ejtone.mars.kernel.core.fault.Fault;

public interface RequestListener {
    public static final RequestListener NoopListener = new RequestListener(){

        @Override
        public void requestSent(Object request) {
        }

        @Override
        public void requestException(Object request, Fault e) {
        }
    };

    public void requestSent(Object var1);

    public void requestException(Object var1, Fault var2);

    public static class DelegateRequestListener
    implements RequestListener {
        protected RequestListener delegate;

        public DelegateRequestListener(RequestListener listener) {
            this.delegate = listener == null ? NoopListener : listener;
        }

        @Override
        public void requestSent(Object request) {
            this.delegate.requestSent(request);
        }

        @Override
        public void requestException(Object request, Fault e) {
            this.delegate.requestException(request, e);
        }
    }

    public static class AdapterRequestListener
    implements RequestListener {
        @Override
        public void requestSent(Object request) {
        }

        @Override
        public void requestException(Object request, Fault e) {
        }
    }
}

