/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

import java.util.ArrayList;
import java.util.List;

public final class AddrUtil {
    private AddrUtil() {
    }

    public static List<Addr> getAddresses(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in list:  ``" + s + "''");
        }
        ArrayList<Addr> addrs = new ArrayList<Addr>();
        for (String hoststuff : s.split("(?:\\s|,|;)+")) {
            if (hoststuff.equals("")) continue;
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hoststuff + "'' in list:  " + s);
            }
            String hostPart = hoststuff.substring(0, finalColon);
            String portNum = hoststuff.substring(finalColon + 1);
            addrs.add(new Addr(hostPart, Integer.parseInt(portNum)));
        }
        return addrs;
    }

    public static List<Addr> getAddresses(List<String> servers) {
        ArrayList<Addr> addrs = new ArrayList<Addr>(servers.size());
        for (String server : servers) {
            int finalColon = server.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + server + "'' in list:  " + server);
            }
            String hostPart = server.substring(0, finalColon);
            String portNum = server.substring(finalColon + 1);
            addrs.add(new Addr(hostPart, Integer.parseInt(portNum)));
        }
        return addrs;
    }

    public static List<String> getStringAddresses(String s) {
        if (s == null) {
            throw new NullPointerException("Null host list");
        }
        if (s.trim().equals("")) {
            throw new IllegalArgumentException("No hosts in list:  ``" + s + "''");
        }
        ArrayList<String> addrs = new ArrayList<String>();
        for (String hoststuff : s.split("(?:\\s|,|;)+")) {
            if (hoststuff.equals("")) continue;
            int finalColon = hoststuff.lastIndexOf(58);
            if (finalColon < 1) {
                throw new IllegalArgumentException("Invalid server ``" + hoststuff + "'' in list:  " + s);
            }
            String hostPart = hoststuff.substring(0, finalColon);
            String portNum = hoststuff.substring(finalColon + 1);
            addrs.add(hostPart + ":" + portNum);
        }
        return addrs;
    }

    public static final class Addr {
        public static final String LOCALHOST_STR = "localhost";
        private String host;
        private int port;

        public Addr(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Addr) {
                Addr hp = (Addr)obj;
                String thisHost = this.convertHost(this.host);
                String hpHost = this.convertHost(hp.host);
                return this.port == hp.port && thisHost.equals(hpHost);
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.convertHost(this.host).hashCode() + this.port;
        }

        public String toString() {
            return this.host + ":" + this.port;
        }

        private String convertHost(String host) {
            if (host.equals("127.0.0.1")) {
                return LOCALHOST_STR;
            }
            if (host.equals("::1")) {
                return LOCALHOST_STR;
            }
            return host;
        }
    }
}

