/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeUtil {
    public static final String dateFormat = "yyyyMMdd";
    public static final String timeFormat = "HHmmss";
    public static final String dateTimeFormat = "yyyyMMddHHmmss";
    public static final String dateTimeMsFormat = "yyyyMMddHHmmssSSS";
    public static final String dateSecondFormat = "yyyyMMddHHmm";

    public static String getDateTime() {
        return new SimpleDateFormat(dateTimeFormat).format(Calendar.getInstance().getTime());
    }

    public static String getDate() {
        return new SimpleDateFormat(dateFormat).format(Calendar.getInstance().getTime());
    }

    public static String getTime() {
        return new SimpleDateFormat(timeFormat).format(Calendar.getInstance().getTime());
    }

    public static String getSecTime() {
        return new SimpleDateFormat(dateSecondFormat).format(Calendar.getInstance().getTime());
    }

    public static String getDate(int nday) {
        Date d = Calendar.getInstance().getTime();
        return new SimpleDateFormat(dateFormat).format(DateTimeUtil.getDate(d, nday));
    }

    public static String getDate(String date, int nday) {
        try {
            SimpleDateFormat f = new SimpleDateFormat(dateFormat);
            Date d = f.parse(date);
            return f.format(DateTimeUtil.getDate(d, nday));
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDate(Date d, int nday) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        c.add(6, nday);
        return c.getTime();
    }

    public static String getDate(String format) {
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(Calendar.getInstance().getTime());
    }

    public static String getDate(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static Date parseDate(String date, String format) {
        SimpleDateFormat sf = new SimpleDateFormat(format);
        try {
            return sf.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static DateAndTime getDateAndTime() {
        return new DateAndTime();
    }

    public static DateAndTime getDateAndTime(Date date) {
        return new DateAndTime(date);
    }

    public static void main(String[] args) throws ParseException {
        System.out.println(DateTimeUtil.getSecTime());
    }

    public static class DateAndTime {
        private String date;
        private String time;

        public DateAndTime() {
            this(Calendar.getInstance().getTime());
        }

        public DateAndTime(Date d) {
            String s = new SimpleDateFormat(DateTimeUtil.dateTimeFormat).format(d);
            this.date = s.substring(0, 8);
            this.time = s.substring(8, 14);
        }

        public String getDate() {
            return this.date;
        }

        public String getTime() {
            return this.time;
        }
    }
}

