/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyWordMatcher {
    private static final Logger logger = LoggerFactory.getLogger(KeyWordMatcher.class);
    private final Map<Character, KeyWordMatcher> wordMap;
    private boolean complete;
    private static int defaultSize = 1024;

    public KeyWordMatcher() {
        this(defaultSize);
    }

    public KeyWordMatcher(int size) {
        this.wordMap = new HashMap<Character, KeyWordMatcher>(size);
    }

    public void add(String word) {
        if (StringUtils.isBlank(word)) {
            return;
        }
        this.addInternal(word.toCharArray(), 0);
    }

    private synchronized void addInternal(char[] wordArray, int startIndex) {
        char c = wordArray[startIndex];
        KeyWordMatcher s = this.wordMap.get(Character.valueOf(c));
        if (s == null) {
            s = new KeyWordMatcher();
            this.wordMap.put(Character.valueOf(c), s);
        }
        if (wordArray.length == ++startIndex) {
            s.complete = true;
            return;
        }
        s.addInternal(wordArray, startIndex);
    }

    public void del(String word) {
        if (StringUtils.isBlank(word)) {
            return;
        }
        this.delInternal(word.toCharArray(), 0);
    }

    private synchronized void delInternal(char[] wordArray, int startIndex) {
        char c = wordArray[startIndex];
        KeyWordMatcher s = this.wordMap.get(Character.valueOf(c));
        if (s == null) {
            return;
        }
        if (wordArray.length == startIndex + 1) {
            if (s.complete) {
                s.complete = false;
                if (s.wordMap.size() == 0) {
                    this.wordMap.remove(Character.valueOf(c));
                }
                return;
            }
            return;
        }
        s.delInternal(wordArray, startIndex + 1);
    }

    public boolean filter(String text) {
        if (StringUtils.isBlank(text)) {
            return false;
        }
        if (this.wordMap.size() == 0) {
            return false;
        }
        char[] textArray = text.toCharArray();
        for (int i = 0; i < textArray.length; ++i) {
            if (!this.filterInternal(textArray, i)) continue;
            return true;
        }
        return false;
    }

    private boolean filterInternal(char[] textArray, int startIndex) {
        KeyWordMatcher s;
        char c = textArray[startIndex];
        if (logger.isDebugEnabled()) {
            logger.debug("filter {} in {}", (Object)ArrayUtils.subarray(textArray, startIndex, textArray.length), (Object)this);
        }
        if ((s = this.wordMap.get(Character.valueOf(c))) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("not found char {} in keyword matcher {}", (Object)Character.valueOf(c), (Object)this);
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("found char {} in keyword matcher {}", (Object)Character.valueOf(c), (Object)this);
        }
        if (s.complete) {
            if (logger.isDebugEnabled()) {
                logger.debug("matched", (Object)Character.valueOf(c));
            }
            return true;
        }
        if (textArray.length == ++startIndex) {
            if (logger.isDebugEnabled()) {
                logger.debug("not matched", (Object)Character.valueOf(c));
            }
            return false;
        }
        return s.filterInternal(textArray, startIndex);
    }

    public String toString() {
        List<String> l = this.toStringArray();
        if (l == null) {
            return "Empty";
        }
        StringBuilder s = new StringBuilder(1024);
        s.append("[ ");
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            s.append(l.get(i)).append(", ");
        }
        s.setLength(s.length() - 2);
        s.append(" ]");
        return s.toString();
    }

    private List<String> toStringArray() {
        ArrayList<String> l = new ArrayList<String>();
        Set<Character> set = this.wordMap.keySet();
        if (set == null) {
            return l;
        }
        for (Character c : set) {
            KeyWordMatcher service = this.wordMap.get(c);
            if (service.complete) {
                l.add(c + "");
            }
            List<String> slist = service.toStringArray();
            int size = slist.size();
            for (int i = 0; i < size; ++i) {
                l.add(c + slist.get(i));
            }
        }
        return l;
    }

    public int size() {
        return this.wordMap.size();
    }

    public static void main(String[] args) {
        KeyWordMatcher m = new KeyWordMatcher();
        System.out.println(m.filter("12345678901234567890"));
        m.add("11");
        System.out.println(m.filter("12345678901234567890"));
        m.add("25");
        System.out.println(m.filter("12345678901234567890"));
        m.add("\u8d64\u88f8");
        System.out.println(m.filter("\u8d64\u88f8\u7684"));
        m.del("\u8d64\u88f8");
        System.out.println(m.filter("\u8d64\u88f8\u7684"));
        m.add("naked");
        System.out.println(m.filter("I'm naked"));
        m.add("na");
        System.out.println(m.filter("I'm naked"));
        m.del("na");
        m.del("naked");
        m.del("\u8d64\u88f8\u88f8");
        System.out.println(m.filter("I'm naked"));
    }
}

