/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

import com.ejtone.mars.kernel.util.DateTimeUtil;
import com.ejtone.mars.kernel.util.config.ConfigUtils;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;

public final class MsgId {
    private int nodeId = ConfigUtils.getInt("mars_id", 1) + ConfigUtils.getInt("mars_id_offset", 0);
    private AtomicInteger seq = new AtomicInteger();
    private static long startTime = DateTimeUtil.parseDate("20160501", "yyyyMMdd").getTime();

    public static final MsgId getInstance() {
        return InstanceHolder.instance;
    }

    private MsgId() {
    }

    public void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    public long newMsgId() {
        return this.buildMsgId();
    }

    public String newStringMsgId() {
        return this.buildStringMsgId();
    }

    public static String format18(String msgId) {
        if (msgId.length() != 22) {
            throw new IllegalArgumentException("msgId\u957f\u5ea6\u6709\u8bef");
        }
        Calendar now = Calendar.getInstance();
        Calendar submitDate = Calendar.getInstance();
        submitDate.setTime(DateTimeUtil.parseDate(msgId.substring(0, 10), "MMddHHmmss"));
        submitDate.set(1, now.get(1));
        if (submitDate.getTimeInMillis() > now.getTimeInMillis()) {
            submitDate.set(1, now.get(1) - 1);
        }
        long time = (submitDate.getTimeInMillis() - startTime) / 1000L % 99999999L;
        String s1 = String.format("%08d", time);
        String s2 = msgId.substring(12);
        return s1 + s2;
    }

    public static final String format(long msgId) {
        long mm = msgId;
        long dd = msgId;
        long HH = msgId;
        long MM = msgId;
        long SS = msgId;
        long gw = msgId;
        long sq = msgId;
        mm >>>= 60;
        dd &= 0xF80000000000000L;
        dd >>>= 55;
        HH &= 0x7C000000000000L;
        MM &= 0x3F00000000000L;
        SS &= 0xFC000000000L;
        gw &= 0x3FFFFF0000L;
        return String.format("%1$02d%2$02d%3$02d%4$02d%5$02d%6$07d%7$05d", mm, dd, HH >>>= 50, MM >>>= 44, SS >>>= 38, gw >>>= 16, sq &= 0xFFFFL);
    }

    public static final long format(String msgId) {
        if (msgId == null || !msgId.matches("\\d{22}")) {
            return 0L;
        }
        long mm = Long.parseLong(msgId.substring(0, 2));
        long dd = Long.parseLong(msgId.substring(2, 4));
        long HH = Long.parseLong(msgId.substring(4, 6));
        long MM = Long.parseLong(msgId.substring(6, 8));
        long SS = Long.parseLong(msgId.substring(8, 10));
        long gw = Long.parseLong(msgId.substring(10, 17));
        long sq = Long.parseLong(msgId.substring(17, 22));
        return mm << 60 | dd << 55 | HH << 50 | MM << 44 | SS << 38 | gw << 16 | sq;
    }

    private long buildMsgId() {
        Calendar c = Calendar.getInstance();
        long month = c.get(2) + 1;
        long day = c.get(5);
        long hour = c.get(11);
        long minute = c.get(12);
        long second = c.get(13);
        return month << 60 | day << 55 | hour << 50 | minute << 44 | second << 38 | (long)(this.nodeId << 16) | (long)(this.seq.incrementAndGet() % 65535 & 0xFFFF);
    }

    private String buildStringMsgId() {
        Calendar c = Calendar.getInstance();
        long month = c.get(2) + 1;
        long day = c.get(5);
        long hour = c.get(11);
        long minute = c.get(12);
        long second = c.get(13);
        return String.format("%1$02d%2$02d%3$02d%4$02d%5$02d%6$07d%7$05d", month, day, hour, minute, second, this.nodeId, this.seq.incrementAndGet() % 65535 & 0xFFFF);
    }

    public static void main(String[] args) {
        System.out.println("20170221000907364".substring(0, 14));
    }

    private static class InstanceHolder {
        public static final MsgId instance = new MsgId();

        private InstanceHolder() {
        }
    }
}

