/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

public class SectionMatcher {
    public static final int SECTION_START_POINT = 1;
    private SectionMatcher[] childMatcher = new SectionMatcher[10];
    private boolean complete;

    public void add(String section) {
        if (section == null || 1 >= section.length()) {
            return;
        }
        this.addInternal(section.toCharArray(), 1);
    }

    private synchronized void addInternal(char[] charArray, int startPoint) {
        int c = charArray[startPoint] - 48;
        if (c < 0 || c > 9) {
            return;
        }
        SectionMatcher m = this.childMatcher[c];
        if (m == null) {
            this.childMatcher[c] = m = new SectionMatcher();
        }
        if (startPoint == charArray.length - 1) {
            m.complete = true;
            return;
        }
        m.addInternal(charArray, startPoint + 1);
    }

    public void del(String section) {
        if (section == null || 1 >= section.length()) {
            return;
        }
        this.delInternal(section.toCharArray(), 1);
    }

    private synchronized void delInternal(char[] charArray, int startPoint) {
        int c = charArray[startPoint] - 48;
        if (c < 0 || c > 9) {
            return;
        }
        SectionMatcher m = this.childMatcher[c];
        if (m == null) {
            return;
        }
        if (startPoint == charArray.length - 1) {
            m.complete = false;
            return;
        }
        m.delInternal(charArray, startPoint + 1);
    }

    public boolean match(String mobile) {
        if (mobile == null || 1 >= mobile.length()) {
            return false;
        }
        return this.match(mobile.toCharArray(), 1);
    }

    private boolean match(char[] charArray, int startPoint) {
        int c = charArray[startPoint] - 48;
        if (c < 0 || c > 9) {
            return false;
        }
        SectionMatcher matcher = this.childMatcher[c];
        if (matcher == null) {
            return false;
        }
        if (matcher.complete) {
            return true;
        }
        if (startPoint == charArray.length - 1) {
            return false;
        }
        return matcher.match(charArray, startPoint + 1);
    }

    public static void main(String[] args) {
        SectionMatcher m = new SectionMatcher();
        System.out.println(m.match("13910570075"));
        m.add("139105700751");
        System.out.println(m.match("13910570075"));
        m.add("13910");
        System.out.println(m.match("13910570075"));
        m.add("1391");
        System.out.println(m.match("13910570075"));
        m.del("13910");
        System.out.println(m.match("13910570075"));
        m.del("1391");
        System.out.println(m.match("13910570075"));
        m.add("1");
        System.out.println(m.match("13910570075"));
    }
}

