/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timer {
    private static final Logger logger = LoggerFactory.getLogger(Timer.class);
    private long threshold;
    long clock;

    public Timer() {
        this(0L);
    }

    public Timer(long threshold) {
        this.threshold = threshold;
        this.clock = System.currentTimeMillis();
    }

    public void start() {
        if (logger.isDebugEnabled()) {
            this.clock = System.currentTimeMillis();
        }
    }

    public void cal(String tag) {
        if (logger.isDebugEnabled()) {
            long t = System.currentTimeMillis();
            long diff = t - this.clock;
            if (diff >= this.threshold) {
                logger.debug("{} cost: {} ms", (Object)tag, (Object)diff);
            }
            this.clock = t;
        }
    }

    public long cost() {
        return System.currentTimeMillis() - this.clock;
    }
}

