/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

import com.ejtone.mars.kernel.util.CharsetUtil;
import org.apache.commons.lang.StringEscapeUtils;

public class XmlBuilder {
    private boolean withDeclaration;
    private boolean withCharset;
    private String charset;
    private boolean useFullEmptyTag;
    private String root;
    private StringBuilder sb = new StringBuilder();

    XmlBuilder(boolean withDeclaration, boolean withCharset, String charset, boolean useFullEmptyTag, String root) {
        this.withDeclaration = withDeclaration;
        this.withCharset = withCharset;
        this.charset = charset;
        this.useFullEmptyTag = useFullEmptyTag;
        this.root = root;
    }

    public XmlBuilder startDocument() {
        if (this.withDeclaration) {
            if (this.withCharset) {
                this.sb.append("<?xml version=\"1.0\" encoding=\"").append(this.charset).append("\" ?>");
            } else {
                this.sb.append("<?xml version=\"1.0\" ?>");
            }
        }
        this.sb.append("<").append(this.root).append(">");
        return this;
    }

    public XmlBuilder endDocument() {
        this.sb.append("</").append(this.root).append(">");
        return this;
    }

    public XmlBuilder startTag(String tag) {
        this.sb.append("<").append(tag).append(">");
        return this;
    }

    public XmlBuilder endTag(String tag) {
        this.sb.append("</").append(tag).append(">");
        return this;
    }

    public XmlBuilder addTagSafely(String tag, String value) {
        if (value == null) {
            return this.addTag(tag, value);
        }
        return this.addTag(tag, StringEscapeUtils.escapeXml(value));
    }

    public String getCharset() {
        return this.charset;
    }

    public String toXmlString() {
        return this.sb.toString();
    }

    public byte[] toXmlByteArray() {
        return CharsetUtil.getBytesUnchecked(this.sb.toString(), this.charset);
    }

    public XmlBuilder addTag(String tag, String value) {
        if (value == null) {
            if (this.useFullEmptyTag) {
                this.sb.append("<").append(tag).append(">");
                this.sb.append("</").append(tag).append(">");
            } else {
                this.sb.append("<").append(tag).append(" />");
            }
            return this;
        }
        this.sb.append("<").append(tag).append(">");
        this.sb.append(value);
        this.sb.append("</").append(tag).append(">");
        return this;
    }

    public static class Builder {
        private boolean withDeclaration = true;
        private boolean withCharset = true;
        private String charset = "UTF-8";
        private boolean useFullEmptyTag = true;
        private String root = "root";

        private Builder() {
        }

        public static Builder custom() {
            return new Builder();
        }

        public XmlBuilder build() {
            return new XmlBuilder(this.withDeclaration, this.withCharset, this.charset, this.useFullEmptyTag, this.root);
        }

        public Builder setWithDeclaration(boolean withDeclaration) {
            this.withDeclaration = withDeclaration;
            return this;
        }

        public Builder setWithCharset(boolean withCharset) {
            this.withCharset = withCharset;
            return this;
        }

        public Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder setUseFullEmptyTag(boolean useFullEmptyTag) {
            this.useFullEmptyTag = useFullEmptyTag;
            return this;
        }

        public Builder setRoot(String name) {
            this.root = name;
            return this;
        }
    }
}

