/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class XmlUtil {
    public static final String REG_INVALID_CHAR_FOR_XML1_0 = "[^\t \r \n \ue000-\ufffd \u10000-\u10ffFF]";
    public static final String REG_INVALID_CHAR_FOR_XML1_1 = "[^\u0001-\ud7ff \ue000-\ufffd \u10000-\u10ffFF]";

    public static String wrapXmlText(String xml) {
        return "<![CDATA[" + xml + "]]>";
    }

    public static String cleanInvalidXmlChars(String xml) {
        return xml.replaceAll(REG_INVALID_CHAR_FOR_XML1_0, "");
    }

    public static int intValue(Element parent, String qname) {
        return XmlUtil.intValue(parent, qname, 0);
    }

    public static int intValue(Element parent, String qname, int defaultValue) {
        String text = parent.elementText(qname);
        if (StringUtils.isBlank(text)) {
            return defaultValue;
        }
        return Integer.parseInt(text);
    }

    public static long longValue(Element parent, String qname) {
        return XmlUtil.longValue(parent, qname, 0L);
    }

    public static long longValue(Element parent, String qname, long defaultValue) {
        String text = parent.elementText(qname);
        if (StringUtils.isBlank(text)) {
            return defaultValue;
        }
        return Long.parseLong(text);
    }

    public static boolean booleanValue(Element parent, String qname) {
        return XmlUtil.booleanValue(parent, qname, false);
    }

    public static boolean booleanValue(Element parent, String qname, boolean defaultValue) {
        String text = parent.elementText(qname);
        if (StringUtils.isBlank(text)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(text);
    }

    public static void main(String[] args) {
        System.out.println("aaa\n999\uffff".replaceAll(REG_INVALID_CHAR_FOR_XML1_0, "8"));
    }
}

