/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.concurrent;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingPriorityQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(BlockingPriorityQueue.class);
    private static final long serialVersionUID = 1895807855312277146L;
    private final BlockingQueue<E>[] queues;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private AtomicInteger size = new AtomicInteger(0);
    private PriorityInspector priorityInspector;
    private long capacity;

    public BlockingPriorityQueue(int limit, PriorityInspector inspector) {
        if (limit <= 0 || inspector == null || inspector.getMaxPriority() < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = limit;
        this.priorityInspector = inspector;
        int maxPriority = inspector.getMaxPriority();
        this.queues = new ArrayBlockingQueue[maxPriority + 1];
        for (int i = 0; i <= maxPriority; ++i) {
            this.queues[i] = new ArrayBlockingQueue(limit);
        }
    }

    public long capacity() {
        return this.capacity;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        BlockingQueue<E> q = this.getQueue(e);
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            boolean ok = q.offer(e);
            if (ok && this.size.getAndIncrement() == 0) {
                this.notEmpty.signal();
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        BlockingQueue<E> q = this.getQueue(e);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            boolean ok = q.offer(e, timeout, unit);
            if (ok && this.size.getAndIncrement() == 0) {
                this.notEmpty.signal();
            }
            boolean bl = ok;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E e) throws InterruptedException {
        BlockingQueue<E> q = this.getQueue(e);
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            q.put(e);
            if (this.size.getAndIncrement() == 0) {
                this.notEmpty.signal();
            }
            return;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size.get() == 0) {
                E e = null;
                return e;
            }
            for (int i = this.queues.length - 1; i >= 0; --i) {
                BlockingQueue<E> q = this.queues[i];
                Object e = q.poll();
                if (e == null) continue;
                if (this.size.getAndDecrement() > 1) {
                    this.notEmpty.signal();
                }
                Object e2 = e;
                return e2;
            }
            E e = null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.size.get() == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            E x = this.poll();
            assert (x != null);
            E e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size.get() == 0) {
                E e = null;
                return e;
            }
            for (int i = this.queues.length - 1; i >= 0; --i) {
                BlockingQueue<E> q = this.queues[i];
                Object e = q.peek();
                if (e == null) continue;
                Object e2 = e;
                return e2;
            }
            E e = null;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.size.get();
    }

    @Override
    public int remainingCapacity() {
        int remain = 0;
        this.lock.lock();
        try {
            for (int i = this.queues.length - 1; i >= 0; --i) {
                remain += this.queues[i].remainingCapacity();
            }
            int n = remain;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object e = o;
        this.lock.lock();
        try {
            BlockingQueue<Object> l = this.getQueue(e);
            if (l.remove(o)) {
                this.size.decrementAndGet();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object e = o;
        this.lock.lock();
        try {
            BlockingQueue<Object> l = this.getQueue(e);
            boolean bl = l.contains(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public BlockingQueue<E>[] getQueues() {
        return this.queues;
    }

    public MonitorQueueBean[] monitor() {
        MonitorQueueBean[] beans = new MonitorQueueBean[this.queues.length];
        for (int i = 0; i < this.queues.length; ++i) {
            beans[i] = new MonitorQueueBean();
            beans[i].priority = i;
            beans[i].size = this.queues[i].size();
            beans[i].capacity = this.capacity;
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (this.size.get() == 0) {
                Object[] objectArray = new Object[]{};
                return objectArray;
            }
            Object[] a = null;
            for (int i = this.queues.length - 1; i >= 0; --i) {
                ArrayUtils.addAll(a, this.queues[i].toArray());
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (int i = this.queues.length - 1; i >= 0; --i) {
                Object[] t = (Object[])Array.newInstance(a.getClass().getComponentType(), 0);
                ArrayUtils.addAll(a, this.queues[i].toArray(t));
            }
            T[] TArray = a;
            return TArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] arr = this.toArray();
            if (arr == null || arr.length == 0) {
                String string = "[]";
                return string;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                Object e = arr[i];
                if (i != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(e == this ? "(this Collection)" : e);
            }
            sb.append("]");
            String string = sb.toString();
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e;
            int n = 0;
            while ((e = this.poll()) != null) {
                c.add(e);
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            E e;
            int n;
            for (n = 0; n < maxElements && (e = this.poll()) != null; ++n) {
                c.add(e);
            }
            int n2 = n;
            return n2;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void clear() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            for (int i = this.queues.length - 1; i >= 0; --i) {
                this.queues[i].clear();
            }
            this.size = new AtomicInteger(0);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.toArray());
    }

    private BlockingQueue<E> getQueue(E e) {
        return this.queues[this.safe(this.priorityInspector.getPriority(e))];
    }

    private int safe(int priority) {
        return priority >= this.queues.length ? this.queues.length - 1 : priority;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lock.lock();
        try {
            s.defaultWriteObject();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void main(String[] args) {
        BlockingPriorityQueue<PriorityObject> queue = new BlockingPriorityQueue<PriorityObject>(1000, new PriorityInspector(){

            @Override
            public int getPriority(Object o) {
                PriorityObject p = (PriorityObject)o;
                return p.priority;
            }

            @Override
            public int getMaxPriority() {
                return 4;
            }
        });
        for (int i = 0; i < 1005; ++i) {
            boolean b = queue.offer(new PriorityObject(i % 4));
            if (b) continue;
            logger.error("false for i = {}", (Object)i);
        }
        while (true) {
            PriorityObject o;
            try {
                o = (PriorityObject)queue.take();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
            if (o == null) break;
            logger.debug("priority = {}", (Object)o.priority);
        }
        logger.info("done");
    }

    private static class PriorityObject {
        private int priority;

        public PriorityObject(int priority) {
            this.priority = priority;
        }
    }

    public static class MonitorQueueBean {
        private int priority;
        private long size;
        private long capacity;

        public int getPriority() {
            return this.priority;
        }

        public long getSize() {
            return this.size;
        }

        public long getCapacity() {
            return this.capacity;
        }
    }

    private class Itr
    implements Iterator<E> {
        final Object[] array;
        int cursor;
        int lastRet = -1;

        Itr(Object[] array) {
            this.array = array;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public E next() {
            if (this.cursor >= this.array.length) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.array[this.cursor++];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            Object x = this.array[this.lastRet];
            this.lastRet = -1;
            BlockingPriorityQueue.this.lock.lock();
            try {
                BlockingPriorityQueue.this.remove(x);
            }
            finally {
                BlockingPriorityQueue.this.lock.unlock();
            }
        }
    }

    public static interface PriorityInspector {
        public int getPriority(Object var1);

        public int getMaxPriority();
    }
}

