/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.config;

import com.ejtone.mars.kernel.util.MixUtil;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class ConfigHelper {
    public static final String configPathName = "configPath";
    public static final String configFileName = "configFile";
    public static final String classPathContextName = "classPathContext";
    public static final String fileSystemContextName = "fileSystemContext";
    private static final boolean webapp = ConfigHelper.getBooleanValue(System.getProperty("webapp"), ConfigHelper.class.getClassLoader().getResource("/") != null);
    private static final String configPath = ConfigHelper.getValue(System.getProperty("configPath"), webapp ? ConfigHelper.class.getClassLoader().getResource("/").getPath() : MixUtil.mergeUrl(System.getProperty("user.dir"), "conf/"));
    private static final String configFile = MixUtil.mergeUrl(configPath, ConfigHelper.getValue(System.getProperty("configFile"), "config.xml"));

    public static String getConfigPath() {
        return configPath;
    }

    public static String getConfigFile() {
        return configFile;
    }

    public static String getConfigFile(String configFile) {
        if (new File(configFile).isAbsolute()) {
            return configFile;
        }
        return MixUtil.mergeUrl(configPath, configFile);
    }

    private static String getValue(String value, String defaultValue) {
        return StringUtils.isBlank(value) ? defaultValue : value;
    }

    private static boolean getBooleanValue(String value, boolean defaultValue) {
        return StringUtils.isBlank(value) ? defaultValue : "true".equals(value);
    }
}

