/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.config;

import com.ejtone.mars.kernel.util.config.Config;
import com.ejtone.mars.kernel.util.config.ConfigHelper;
import com.ejtone.mars.kernel.util.config.XmlConfigLoader;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PropertyPlaceholderHelper;

public class ConfigUtils
extends ConfigHelper {
    private static final Logger logger = LoggerFactory.getLogger(ConfigUtils.class);
    private static Config config;
    private static final PropertyPlaceholderHelper helper;

    public static Properties getAll() {
        return config.getProperties();
    }

    public static String getProperty(String key) {
        return config.getProperty(key);
    }

    public static String getString(String key, String defaultValue) {
        String value = ConfigUtils.getProperty(key);
        return value == null ? defaultValue : value;
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = ConfigUtils.getProperty(key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    public static int getInt(String key, int defaultValue) {
        String value = ConfigUtils.getProperty(key);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static long getLong(String key, long defaultValue) {
        String value = ConfigUtils.getProperty(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    public static List<Config.SpringBeanConfigFile> getSpringBeanConfigFileList() {
        return config.getSpringBeanConfigFileList();
    }

    private static synchronized void load() {
        config = XmlConfigLoader.load(ConfigUtils.getConfigFile());
        config.setProperty("configPath", ConfigUtils.getConfigPath());
        config.setProperty("configFile", ConfigUtils.getConfigFile());
        ConfigUtils.replacePlaceholder(config.getProperties());
        ConfigUtils.debugConfig();
    }

    private static void debugConfig() {
        for (Map.Entry<Object, Object> e : config.getProperties().entrySet()) {
            logger.info("{} = {}", e.getKey(), e.getValue());
        }
    }

    private static void replacePlaceholder(Properties prop) {
        for (Map.Entry<Object, Object> e : prop.entrySet()) {
            prop.put(e.getKey(), helper.replacePlaceholders((String)e.getValue(), prop));
        }
    }

    public static void main(String[] args) {
        System.out.println("dataPath = " + ConfigUtils.getProperty("dataPath"));
    }

    static {
        helper = new PropertyPlaceholderHelper("${", "}");
        ConfigUtils.load();
    }
}

