/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.config;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropConfigLoader.class);

    public static Properties load(String configFile) {
        return PropConfigLoader.loadProperties(new File(configFile));
    }

    public static Properties loadProperties(File ... configFiles) {
        Properties prop = new Properties();
        PropConfigLoader.loadFiles(prop, configFiles);
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFiles(Properties prop, File ... configFiles) {
        InputStreamReader reader = null;
        for (File configFile : configFiles) {
            if (!configFile.exists()) {
                logger.error("file {} not exist, ignore", (Object)configFile);
                continue;
            }
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(configFile), "UTF-8");
                prop.load(reader);
            }
            catch (Exception e) {
                try {
                    logger.error("", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    reader = null;
                    throw throwable;
                }
                IOUtils.closeQuietly(reader);
                reader = null;
                continue;
            }
            IOUtils.closeQuietly(reader);
            reader = null;
        }
    }

    public static Properties loadPath(String path) {
        Properties prop = new Properties();
        if (path == null) {
            return prop;
        }
        try {
            File[] array = new File(path).listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String filename = pathname.getName().toLowerCase();
                    return filename.endsWith(".properties") && !filename.equals("log4j.properties");
                }
            });
            if (array == null || array.length == 0) {
                return prop;
            }
            PropConfigLoader.loadFiles(prop, array);
            return prop;
        }
        catch (Exception ex) {
            logger.error("", ex);
            return prop;
        }
    }
}

