/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.config;

import com.alibaba.fastjson.JSON;
import com.ejtone.mars.kernel.util.config.Config;
import com.ejtone.mars.kernel.util.config.ConfigHelper;
import com.ejtone.mars.kernel.util.config.PropConfigLoader;
import java.io.File;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(XmlConfigLoader.class);

    public static Config load(String configFile) {
        return XmlConfigLoader.load(new Config(), new File(configFile), true);
    }

    private static Config load(Config config, File configFile, boolean superFile) {
        if (!configFile.exists()) {
            logger.error("file {} not exist, ignore", (Object)configFile.getPath());
            return config;
        }
        try {
            Document document = new SAXReader().read(configFile);
            Element root = document.getRootElement();
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                XmlConfigLoader.readElement(config, "", (Element)i.next(), false);
            }
            return config;
        }
        catch (DocumentException e) {
            logger.error("load file {} exception : {}", (Object)configFile.getPath(), (Object)e.toString());
            return config;
        }
    }

    private static void readProperty(Config config, String parent, Element e, boolean splice) {
        String pn = e.attributeValue("name");
        String pv = e.attributeValue("value");
        if (StringUtils.isBlank(pn)) {
            logger.error("not found name in property");
            return;
        }
        if (pv == null) {
            pv = "";
        }
        if (splice) {
            pn = parent + pn;
        }
        config.setProperty(pn, pv);
    }

    private static void readImport(Config config, String parent, Element e) {
        String filename = e.attributeValue("src");
        if (StringUtils.isBlank(filename)) {
            logger.error("not found import src, ignore");
            return;
        }
        if (filename.endsWith(".xml")) {
            XmlConfigLoader.load(config, new File(ConfigHelper.getConfigFile(filename)), false);
        } else {
            PropConfigLoader.loadFiles(config.getProperties(), new File(ConfigHelper.getConfigFile(filename)));
        }
    }

    private static void readSpringContext(Config config, Element e) {
        Iterator i = e.elementIterator();
        while (i.hasNext()) {
            Element el = (Element)i.next();
            String file = el.attributeValue("name");
            if (StringUtils.isBlank(file)) {
                logger.error("not found spring file name, ignore");
                return;
            }
            if (el.getName().equals("classpath")) {
                config.addSpringBeanConfigFile(true, file);
                continue;
            }
            if (el.getName().equals("file")) {
                config.addSpringBeanConfigFile(false, file);
                continue;
            }
            logger.error("illegal element name : {}", (Object)el.getName());
        }
    }

    private static void readElement(Config config, String parent, Element e, boolean splice) {
        String name;
        switch (name = e.getName()) {
            case "property": {
                XmlConfigLoader.readProperty(config, parent, e, splice);
                return;
            }
            case "import": {
                XmlConfigLoader.readImport(config, parent, e);
                return;
            }
            case "spring-context": {
                XmlConfigLoader.readSpringContext(config, e);
                return;
            }
        }
        logger.debug("reading element : {} ", (Object)name);
        String s = e.attributeValue("splice");
        splice = !StringUtils.isBlank(s) && s.equals("true");
        Iterator i = e.elementIterator();
        while (i.hasNext()) {
            XmlConfigLoader.readElement(config, name, (Element)i.next(), splice);
        }
        logger.debug("reading element : {} end", (Object)name);
    }

    public static void main(String[] args) {
        Config config = XmlConfigLoader.load("./conf/config.xml");
        System.out.println(JSON.toJSONString(config));
    }
}

