/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.flowctrl;

import com.ejtone.mars.kernel.util.Timer;
import com.ejtone.mars.kernel.util.flowctrl.FlowControler;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowControler
implements FlowControler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultFlowControler.class);
    private int limit;
    private int size;
    private int current;
    private long period;
    private long[] controler;
    private ReentrantLock lock;
    private Condition condition;
    private Semaphore sem;

    public DefaultFlowControler() {
        this.size = this.limit = -1;
        this.period = TimeUnit.MILLISECONDS.toNanos(100L);
        this.lock = new ReentrantLock(true);
        this.condition = this.lock.newCondition();
        this.sem = new Semaphore(1);
    }

    public DefaultFlowControler(int limit) {
        this(limit, 100);
    }

    public DefaultFlowControler(int limit, int period) {
        this.size = this.limit = -1;
        this.period = TimeUnit.MILLISECONDS.toNanos(100L);
        this.lock = new ReentrantLock(true);
        this.condition = this.lock.newCondition();
        this.sem = new Semaphore(1);
        this.init(limit, period);
    }

    public long getFlowLimit() {
        return this.limit;
    }

    public long getFlowPeriod() {
        return this.period;
    }

    private void init(int limit, int period) {
        this.lock.lock();
        try {
            if (limit > 0) {
                this.period = TimeUnit.MILLISECONDS.toNanos(period);
                this.current = 0;
                this.controler = new long[limit];
                this.size = limit;
            }
            this.limit = limit;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setLimit(int limit) {
        this.lock.lock();
        try {
            if (limit > 0) {
                if (limit > this.size) {
                    this.current = 0;
                    long[] controler = new long[limit];
                    if (this.controler != null) {
                        System.arraycopy(this.controler, 0, controler, 0, this.limit);
                    }
                    this.controler = controler;
                    this.size = limit;
                } else if (this.current >= limit) {
                    this.current = 0;
                }
                this.limit = limit;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void update(int limit, int period) {
        if (this.period == (long)period) {
            this.setLimit(limit);
        } else {
            this.init(limit, period);
        }
    }

    @Override
    public void control(int number) throws InterruptedException {
        this.sem.acquire();
        try {
            for (int i = 0; i < number; ++i) {
                this.control();
            }
        }
        finally {
            this.sem.release();
        }
    }

    @Override
    public void control() throws InterruptedException {
        this.lock.lock();
        try {
            while (true) {
                long sleeptime;
                if ((sleeptime = this.tryAccept(0L)) == 0L) {
                    return;
                }
                this.condition.awaitNanos(sleeptime);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean accept(int number) {
        return this.tryAccept(0L, number) == 0L;
    }

    @Override
    public boolean accept() {
        return this.tryAccept(0L) == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limit(int number) {
        if (this.limit <= 0) {
            return;
        }
        int count = number - 1;
        if (count <= 0) {
            return;
        }
        this.lock.lock();
        try {
            long currtime = System.nanoTime();
            while (count > 0) {
                if (this.tryAccept(currtime) != 0L) {
                    long passtime = this.getPassTime(count);
                    for (int i = 0; i < this.limit; ++i) {
                        this.controler[i] = passtime;
                    }
                    break;
                }
                --count;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long tryAccept(long currtime) {
        if (this.limit <= 0) {
            return 0L;
        }
        this.lock.lock();
        try {
            long difftime;
            if (currtime == 0L) {
                currtime = System.nanoTime();
            }
            if ((difftime = currtime - this.controler[this.current]) >= this.period) {
                this.controler[this.current] = currtime;
                this.current = (this.current + 1) % this.limit;
                long l = 0L;
                return l;
            }
            long l = this.period - difftime;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long tryAccept(long currtime, int number) {
        long difftime;
        if (this.limit <= 0 || number <= 0) {
            return 0L;
        }
        this.lock.lock();
        try {
            int position;
            if (currtime == 0L) {
                currtime = System.nanoTime();
            }
            if ((difftime = currtime - this.controler[position = (this.current + number - 1) % this.limit]) >= this.period) {
                for (int i = 0; i < number; ++i) {
                    this.controler[(this.current + i) % this.limit] = currtime;
                }
                this.current = (position + 1) % this.limit;
                long l = 0L;
                return l;
            }
        }
        finally {
            this.lock.unlock();
        }
        return this.period - difftime;
    }

    protected long getPassTime(int number) {
        if (this.limit <= 0) {
            return 0L;
        }
        int div = number / this.limit;
        int rem = number % this.limit;
        int position = (this.current + rem - 1) % this.limit;
        return this.controler[position] + (long)div * this.period;
    }

    protected static void TestControl() {
        DefaultFlowControler c = new DefaultFlowControler(2, 1000);
        Timer timer = new Timer();
        for (int i = 0; i < 30; ++i) {
            try {
                c.control(1);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        timer.cal("");
    }

    protected static void TestMultiControl() {
        final DefaultFlowControler c = new DefaultFlowControler(2, 1000);
        for (int j = 0; j < 5; ++j) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int cnt = 0;
                    Timer timer = new Timer();
                    for (int i = 0; i < 10; ++i) {
                        try {
                            c.control();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ++cnt;
                    }
                    timer.cal("" + cnt);
                }
            }).start();
        }
    }

    protected static void TestAccept() {
        DefaultFlowControler c = new DefaultFlowControler(5, 100);
        int cnt = 0;
        Timer timer = new Timer();
        for (int i = 0; i < 300; ++i) {
            if (c.accept(10)) {
                ++cnt;
            }
            try {
                Thread.sleep(2L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println(cnt);
        timer.cal("");
    }

    protected static void TestMultiAccept() {
        final DefaultFlowControler c = new DefaultFlowControler(5, 100);
        for (int j = 0; j < 5; ++j) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    int cnt = 0;
                    Timer timer = new Timer();
                    for (int i = 0; i < 3000; ++i) {
                        if (c.accept()) {
                            ++cnt;
                        }
                        try {
                            Thread.sleep(2L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    timer.cal("" + cnt);
                }
            }).start();
        }
    }

    protected static void TestMultiControlerAccept() {
        final DefaultFlowControler c = new DefaultFlowControler(10, 100);
        for (int j = 0; j < 5; ++j) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Timer timer = new Timer();
                    for (int i = 0; i < 100; ++i) {
                        try {
                            c.control(3);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    timer.cal("");
                }
            }).start();
        }
    }

    protected static void TestUpdate() {
        DefaultFlowControler f = new DefaultFlowControler(5, 1000);
        f.setLimit(30);
        f.setLimit(10);
    }

    protected static void TestControlAndAccept() {
        final DefaultFlowControler f1 = new DefaultFlowControler(15, 1000);
        final DefaultFlowControler f2 = new DefaultFlowControler(30, 2000);
        ThreadPoolExecutor t1 = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10000));
        final ThreadPoolExecutor t2 = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10000));
        for (int i = 0; i < 1000; ++i) {
            t1.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        f1.control(15);
                        logger.info("11111111111111111111{}", (Object)System.currentTimeMillis());
                        t2.execute(new Runnable(){

                            @Override
                            public void run() {
                                logger.info("222222222222222222{}", (Object)System.currentTimeMillis());
                                boolean accept = f2.accept(15);
                                if (accept) {
                                    logger.info("good");
                                } else {
                                    logger.error("overlimit!!!!!!!!!!!");
                                }
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void main(String[] args) {
        DefaultFlowControler.TestControlAndAccept();
    }
}

