/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.listener;

import com.ejtone.mars.kernel.util.listener.ListenerProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DelegateListenerProvider<T>
implements ListenerProvider<T> {
    private List<T> listeners = new ArrayList<T>();
    private Lock lock = new ReentrantLock();
    private ListenerInspector<T> inspector;

    public DelegateListenerProvider(ListenerInspector<T> inspector) {
        this.inspector = inspector;
    }

    public void notifyListeners(Object ... args) {
        this.lock.lock();
        try {
            Iterator<T> i = this.listeners.iterator();
            while (i.hasNext()) {
                this.inspector.notify(i.next(), args);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void nofityListener(T listener, Object ... args) {
        this.inspector.notify(listener, args);
    }

    public void setListeners(Collection<T> c) {
        this.lock.lock();
        try {
            Iterator<T> i = c.iterator();
            while (i.hasNext()) {
                this.listeners.add(i.next());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void registListener(T listener) {
        this.lock.lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeListener(T listener) {
        this.lock.lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface ListenerInspector<T> {
        public void notify(T var1, Object ... var2);
    }
}

