/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.mapper;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Mapper {
    private static final Logger logger = LoggerFactory.getLogger(Mapper.class);
    private MappedByteBuffer buffer;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mapper(String file, int size) {
        logger.info("Mapper(String, int) - file=" + file + ", size=" + size);
        this.name = file;
        RandomAccessFile raf = null;
        AbstractInterruptibleChannel channel = null;
        this.buffer = null;
        try {
            raf = new RandomAccessFile(file, "rwd");
            if (raf.length() == 0L) {
                byte[] b = new byte[size];
                raf.write(b);
            }
            channel = raf.getChannel();
            this.buffer = ((FileChannel)channel).map(FileChannel.MapMode.READ_WRITE, 0L, size);
        }
        catch (Exception e) {
            logger.error("new Mapper exception:", e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public MappedByteBuffer getBuffer() {
        return this.buffer;
    }
}

