/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.mapper;

import com.ejtone.mars.kernel.util.MixUtil;
import com.ejtone.mars.kernel.util.config.ConfigUtils;
import com.ejtone.mars.kernel.util.mapper.Mapper;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class MapperFactory {
    private static String defaultMapperPath = MixUtil.mergeUrl(ConfigUtils.getString("dataPath", "./data"), "mapper");
    private static Map<String, Mapper> map = new HashMap<String, Mapper>();

    public static Mapper getMapper(String filename, int size) {
        return MapperFactory.getMapper(defaultMapperPath, filename, size);
    }

    public static synchronized Mapper getMapper(String pathname, String filename, int size) {
        String file = pathname.endsWith("/") ? pathname + filename : pathname + "/" + filename;
        Mapper mapper = map.get(file);
        if (mapper == null) {
            new File(pathname).mkdirs();
            mapper = new Mapper(file, size);
            if (mapper != null) {
                map.put(file, mapper);
            }
        }
        return mapper;
    }

    public static synchronized void close(Mapper mapper) {
        map.remove(mapper.getName());
    }

    public static synchronized void closeAll() {
        map.clear();
    }
}

