/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.mapper;

import com.ejtone.mars.kernel.util.mapper.Mapper;
import com.ejtone.mars.kernel.util.mapper.MapperFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperSequence {
    private static final Logger logger = LoggerFactory.getLogger(MapperSequence.class);
    private Mapper mapper;
    private long minValue;
    private long maxValue;
    private long curValue = 1L;
    private long requireNumber;
    private int lockNumber;
    private SequenceValue[] values;
    private ReentrantLock[] locks;
    private AtomicBoolean initialized = new AtomicBoolean();

    public MapperSequence(String name, long minValue, long maxValue) {
        this(name, minValue, maxValue, 1024, 16);
    }

    public MapperSequence(String name, long minValue, long maxValue, int requireNumber, int lockNumber) {
        Mapper mapper;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.requireNumber = requireNumber;
        this.lockNumber = lockNumber;
        if (this.maxValue < this.minValue) {
            this.maxValue = this.minValue;
        }
        if ((mapper = MapperFactory.getMapper(name, 8)) == null) {
            throw new RuntimeException("create mapper " + name + " failed");
        }
        this.setMapper(mapper);
        this.values = new SequenceValue[lockNumber];
        this.locks = new ReentrantLock[lockNumber];
        for (int i = 0; i < lockNumber; ++i) {
            this.values[i] = new SequenceValue();
            this.locks[i] = new ReentrantLock();
        }
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            for (int i = 0; i < this.lockNumber; ++i) {
                this.acquire(this.values[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long next() {
        int i = (int)(Thread.currentThread().getId() % (long)this.lockNumber);
        ReentrantLock l = this.locks[i];
        l.lock();
        try {
            Long l2 = this.values[i].value();
            return l2;
        }
        finally {
            l.unlock();
        }
    }

    private synchronized void acquire(SequenceValue value) {
        if (this.curValue >= this.maxValue - this.requireNumber + 1L) {
            long max = this.maxValue;
            value.setCurValue(this.curValue);
            value.setMaxValue(this.maxValue);
            this.curValue = this.minValue;
        } else {
            long max = this.curValue + this.requireNumber - 1L;
            value.setCurValue(this.curValue);
            value.setMaxValue(max);
            this.curValue = max + 1L;
        }
        if (this.mapper != null && this.mapper.getBuffer() != null) {
            this.mapper.getBuffer().putLong(0, this.curValue);
            this.mapper.getBuffer().force();
        }
    }

    private void setMapper(Mapper mapper) {
        this.mapper = mapper;
        long curValue = mapper.getBuffer().getLong(0);
        if (curValue < this.minValue) {
            curValue = this.minValue;
        }
        logger.info("sequence initialized, curvalue = {}", (Object)curValue);
        this.curValue = curValue;
    }

    private class SequenceValue {
        private long maxValue = -1L;
        private long curValue;

        private SequenceValue() {
        }

        public void setMaxValue(long maxValue) {
            this.maxValue = maxValue;
        }

        public void setCurValue(long curValue) {
            this.curValue = curValue;
        }

        public long value() {
            if (this.curValue > this.maxValue) {
                MapperSequence.this.acquire(this);
            }
            return this.curValue++;
        }
    }
}

