/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.monitor;

import com.ejtone.mars.kernel.util.MixUtil;
import com.ejtone.mars.kernel.util.NamedThreadFactory;
import com.ejtone.mars.kernel.util.lifecycle.AbstractLifeCycle;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public abstract class AbstractMonitor
extends AbstractLifeCycle {
    protected static Logger logger = MixUtil.monLogger;
    protected static ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, new NamedThreadFactory("monitor"));
    private int monitorRateMs = 10000;
    private ScheduledFuture<?> monFuture;

    public void setMonitorRateMs(int monitorRateMs) {
        this.monitorRateMs = monitorRateMs;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.monFuture = executor.scheduleAtFixedRate(this.getMonitorTask(), this.monitorRateMs, this.monitorRateMs, TimeUnit.MILLISECONDS);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.monFuture != null) {
            this.monFuture.cancel(false);
            this.monFuture = null;
        }
        super.doStop();
    }

    protected abstract Runnable getMonitorTask();
}

