/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.monitor;

import com.ejtone.mars.kernel.util.MixUtil;
import com.ejtone.mars.kernel.util.concurrent.BlockingPriorityQueue;
import com.ejtone.mars.kernel.util.monitor.AbstractMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;

public class ExecutorMonitor
extends AbstractMonitor {
    private static final Logger logger = MixUtil.monLogger;
    private List<NamedExecutor> list = new ArrayList<NamedExecutor>();

    public static ExecutorMonitor getInstance() {
        return InstanceHolder.instance;
    }

    private ExecutorMonitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regist(String name, ThreadPoolExecutor executor) {
        List<NamedExecutor> list = this.list;
        synchronized (list) {
            this.list.add(new NamedExecutor(name, executor));
            logger.info("regist executor {}:{} to monitor", (Object)name, (Object)System.identityHashCode(executor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregist(ThreadPoolExecutor executor) {
        List<NamedExecutor> list = this.list;
        synchronized (list) {
            NamedExecutor ne = this.removeExecutor(executor);
            if (ne != null) {
                logger.info("unregist executor {}:{} from monitor", (Object)ne.name, (Object)System.identityHashCode(executor));
            }
        }
    }

    private NamedExecutor removeExecutor(ThreadPoolExecutor executor) {
        Iterator<NamedExecutor> i = this.list.iterator();
        while (i.hasNext()) {
            NamedExecutor ne = i.next();
            if (ne.executor != executor) continue;
            i.remove();
            return ne;
        }
        return null;
    }

    public void setExecutors(Collection<NamedExecutor> c) {
        if (c == null) {
            return;
        }
        this.list.addAll(c);
    }

    @Override
    protected Runnable getMonitorTask() {
        return new MonitorTask();
    }

    private class MonitorTask
    implements Runnable {
        private MonitorTask() {
        }

        @Override
        public void run() {
            try {
                this.runTask();
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }

        private void runTask() {
            for (NamedExecutor ne : ExecutorMonitor.this.list) {
                ThreadPoolExecutor threadPool = ne.executor;
                String name = ne.name;
                BlockingQueue<Runnable> queue = threadPool.getQueue();
                if (queue instanceof ArrayBlockingQueue) {
                    ArrayBlockingQueue aq = (ArrayBlockingQueue)queue;
                    logger.info("Monitor Executor {} : core = {}, curr = {}/{}, jobs = {}/{}", name, threadPool.getCorePoolSize(), threadPool.getPoolSize(), threadPool.getMaximumPoolSize(), aq.size(), aq.remainingCapacity() + aq.size());
                    continue;
                }
                if (queue instanceof BlockingPriorityQueue) {
                    BlockingPriorityQueue bq = (BlockingPriorityQueue)queue;
                    BlockingPriorityQueue.MonitorQueueBean[] beans = bq.monitor();
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < beans.length; ++j) {
                        if (j != 0) {
                            sb.append(", ");
                        }
                        sb.append("q-").append(beans[j].getPriority()).append(":").append(beans[j].getSize()).append("/").append(beans[j].getCapacity());
                    }
                    logger.info("Monitor Executor {} : core = {}, curr = {}/{}, jobs = {}", name, threadPool.getCorePoolSize(), threadPool.getPoolSize(), threadPool.getMaximumPoolSize(), sb.toString());
                    continue;
                }
                logger.info("Monitor Executor {} : core = {}, curr = {}/{}, jobs = {}/{}", name, threadPool.getCorePoolSize(), threadPool.getPoolSize(), threadPool.getMaximumPoolSize(), queue.size(), -1);
            }
        }
    }

    private static class InstanceHolder {
        public static final ExecutorMonitor instance = new ExecutorMonitor();

        private InstanceHolder() {
        }
    }

    private static class NamedExecutor {
        private String name;
        private ThreadPoolExecutor executor;

        public NamedExecutor(String name, ThreadPoolExecutor executor) {
            this.name = name;
            this.executor = executor;
        }
    }
}

