/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.priority;

import com.ejtone.mars.kernel.util.priority.PriorityMapper;

public class DefaultPriorityMapper
implements PriorityMapper {
    private int[] mapper = new int[]{0, 1, 2, 3, 3, 3, 3, 3, 3, 3};
    private boolean orderAsc = true;
    private int maxPriority = this.mapper[this.mapper.length - 1];

    @Override
    public int convert(int intValue) {
        if (intValue < 0) {
            return 0;
        }
        if (intValue >= this.mapper.length) {
            return this.orderAsc ? this.maxPriority : 0;
        }
        return this.mapper[intValue];
    }

    @Override
    public int safe(int priority) {
        return priority < 0 ? 0 : (priority > this.maxPriority ? this.maxPriority : priority);
    }

    @Override
    public int maxPriority() {
        return this.maxPriority;
    }

    public void setStringMapper(String mapperString) throws Exception {
        this.setMapper(DefaultPriorityMapper.toIntArray(mapperString));
    }

    public void setMapper(int[] mapper) throws Exception {
        if (mapper.length == 0 || !this.validate(mapper)) {
            throw new Exception("\u4f18\u5148\u7ea7\u914d\u7f6e\u4e0d\u5408\u6cd5");
        }
        this.maxPriority = this.orderAsc ? mapper[mapper.length - 1] : mapper[0];
        this.mapper = mapper;
    }

    private static final int[] toIntArray(String s) {
        String[] stringArray = s.split(",");
        int[] intArray = new int[stringArray.length];
        int size = stringArray.length;
        for (int i = 0; i < size; ++i) {
            intArray[i] = Integer.parseInt(stringArray[i]);
        }
        return intArray;
    }

    private final boolean validate(int[] priority) {
        int lastIndex = priority.length - 1;
        if (priority[0] > priority[lastIndex]) {
            this.orderAsc = false;
            if (priority[lastIndex] != 0) {
                return false;
            }
            int size = lastIndex;
            for (int i = 0; i < size; ++i) {
                int d = priority[i] - priority[i + 1];
                if (d == 0 || d == 1) continue;
                return false;
            }
        } else {
            if (priority[0] != 0) {
                return false;
            }
            int size = lastIndex;
            for (int i = 0; i < size; ++i) {
                int d = priority[i + 1] - priority[i];
                if (d == 0 || d == 1) continue;
                return false;
            }
        }
        return true;
    }
}

