/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.resource;

import com.ejtone.mars.kernel.util.resource.AbstractResourceLoader;
import com.ejtone.mars.kernel.util.resource.ResourceInspector;
import com.ejtone.mars.kernel.util.resource.ResourceListener;
import com.ejtone.mars.kernel.util.resource.ResourceProvider;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceProvider<T>
extends AbstractResourceLoader
implements ResourceProvider<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceProvider.class);
    protected ResourceInspector<T> inspector;
    private Map<Object, T> map = new HashMap<Object, T>();
    private List<ResourceListener<T>> list = new ArrayList<ResourceListener<T>>();

    public AbstractResourceProvider(ResourceInspector<T> inspector) {
        this.inspector = inspector;
    }

    @Override
    public T get(Object id) {
        return this.map.get(id);
    }

    protected Class<T> getTClass() {
        return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Override
    public synchronized void regist(T res) {
        T old = this.map.get(this.inspector.getId(res));
        if (old != null) {
            if (this.inspector.equals(old, res)) {
                logger.debug("resource {} no change", this.inspector.getId(res));
            } else {
                this.map.put(this.inspector.getId(res), res);
                logger.info("update resource {}", this.inspector.getId(res));
                this.resourceUpdate(res, old);
            }
        } else {
            this.map.put(this.inspector.getId(res), res);
            logger.info("regist resource {}", this.inspector.getId(res));
            this.resourceAdd(res);
        }
    }

    @Override
    public synchronized void remove(T res) {
        T old = this.map.remove(this.inspector.getId(res));
        if (old != null) {
            logger.info("unregist resource {}", this.inspector.getId(res));
            this.resourceDel(old);
        }
    }

    @Override
    public synchronized void removeByKey(Object key) {
        T old = this.map.remove(key);
        if (old != null) {
            logger.info("unregist resource {}", key);
            this.resourceDel(old);
        }
    }

    @Override
    public synchronized List<T> getAll() {
        ArrayList<T> l = new ArrayList<T>(this.map.values());
        return l;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized void registListener(ResourceListener<T> listener) {
        if (!this.registInternal(listener)) {
            return;
        }
        for (T r : this.map.values()) {
            try {
                if (!listener.interest(r)) continue;
                listener.add(r);
            }
            catch (Exception e) {
                logger.error("add resource {} to listener {} exception", this.inspector.getId(r), (Object)listener.getName());
                logger.error("exception info : ", e);
            }
        }
    }

    @Override
    public synchronized void removeListener(ResourceListener<T> listener) {
        Iterator<ResourceListener<T>> i = this.list.iterator();
        while (i.hasNext()) {
            ResourceListener<T> l = i.next();
            if (!l.equals(listener)) continue;
            i.remove();
            logger.info("listener {} unregisted", (Object)listener.getName());
            return;
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        this.list = new ArrayList<ResourceListener<T>>();
    }

    @Override
    protected void doLoad() {
        try {
            Collection<T> c = this.doLoad0();
            if (c != null) {
                this.updateResource(c);
            }
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    protected Collection<T> doLoad0() throws Exception {
        return null;
    }

    protected synchronized void updateResource(Collection<T> c) {
        HashMap<Object, T> newer = new HashMap<Object, T>();
        for (T t : c) {
            newer.put(this.inspector.getId(t), t);
        }
        Map<Object, T> older = this.map;
        this.map = newer;
        for (T t : c) {
            Object key = this.inspector.getId(t);
            T o = older.remove(key);
            if (o == null) {
                logger.info("regist resource {}", this.inspector.getId(t));
                this.resourceAdd(t);
                continue;
            }
            if (!this.inspector.equals(t, o)) {
                logger.info("update resource {}", this.inspector.getId(t));
                this.resourceUpdate(t, o);
                continue;
            }
            logger.debug("resource {} no change", this.inspector.getId(t));
        }
        Iterator<T> i = older.values().iterator();
        while (i.hasNext()) {
            this.resourceDel(i.next());
        }
    }

    protected void resourceAdd(T res) {
        for (ResourceListener<T> r : this.list) {
            try {
                if (!r.interest(res)) continue;
                r.add(res);
            }
            catch (Throwable e) {
                logger.error("add resource {} to listener {} exception", this.inspector.getId(res), (Object)r.getName());
                logger.error("exception info : ", e);
            }
        }
    }

    protected void resourceUpdate(T res, T old) {
        for (ResourceListener<T> r : this.list) {
            try {
                if (r.contains(old)) {
                    r.update(res, old);
                    continue;
                }
                if (!r.interest(res)) continue;
                r.add(res);
            }
            catch (Throwable e) {
                logger.error("update resource {} to listener {} exception", this.inspector.getId(res), (Object)r.getName());
                logger.error("exception info : ", e);
            }
        }
    }

    protected void resourceDel(T res) {
        for (ResourceListener<T> r : this.list) {
            try {
                if (!r.contains(res)) continue;
                r.del(res);
            }
            catch (Throwable e) {
                logger.error("delete resource {} from listener {} exception", this.inspector.getId(res), (Object)r.getName());
                logger.error("exception info : ", e);
            }
        }
    }

    private synchronized boolean registInternal(ResourceListener<T> listener) {
        for (ResourceListener<T> r : this.list) {
            if (!r.equals(listener)) continue;
            logger.warn("listener {} already registed", (Object)listener.getName());
            return false;
        }
        this.list.add(listener);
        logger.info("listener {} registed", (Object)listener.getName());
        return true;
    }
}

