/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.kernel.util.selector;

import com.ejtone.mars.kernel.util.selector.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingSelector<T>
implements Selector<T> {
    private static final Logger logger = LoggerFactory.getLogger(RollingSelector.class);
    private final List<T> list;
    private long pos = 0L;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition available = this.lock.newCondition();

    public RollingSelector() {
        this.list = new ArrayList<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock.lock();
        try {
            boolean add = this.addOrUpdate(object);
            this.available.signalAll();
            boolean bl = add;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(T o) {
        this.lock.lock();
        try {
            logger.info("remove resource {} from selector", (Object)o);
            boolean bl = this.list.remove(o);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> removeAll() {
        this.lock.lock();
        try {
            ArrayList<T> l = new ArrayList<T>(this.list);
            this.list.clear();
            ArrayList<T> arrayList = l;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T next() {
        this.lock.lock();
        try {
            int size = this.list.size();
            if (size == 0) {
                T t = null;
                return t;
            }
            int index = (int)(this.pos++ % (long)size);
            T t = this.list.get(index);
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    public T waitNext() throws InterruptedException {
        this.lock.lock();
        try {
            while (true) {
                T r;
                if ((r = this.next()) != null) {
                    T t = r;
                    return t;
                }
                this.awaitAvailable();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public T waitNext(long timeout) throws InterruptedException {
        this.lock.lock();
        try {
            while (true) {
                T r;
                if ((r = this.next()) != null) {
                    T t = r;
                    return t;
                }
                if (timeout > 0L) {
                    this.awaitAvailable(timeout);
                    continue;
                }
                if (timeout == 0L) {
                    T t = null;
                    return t;
                }
                this.awaitAvailable();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> getAll() {
        this.lock.lock();
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.list);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    public void awaitAvailable() throws InterruptedException {
        if (this.list.size() > 0) {
            return;
        }
        this.lock.lock();
        try {
            this.available.await();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitAvailable(long timeout) throws InterruptedException {
        if (this.list.size() > 0) {
            return;
        }
        this.lock.lock();
        try {
            this.available.await(timeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addOrUpdate(T o) {
        this.lock.lock();
        try {
            Iterator<T> i = this.list.iterator();
            while (i.hasNext()) {
                T old = i.next();
                if (old == o) {
                    boolean bl = false;
                    return bl;
                }
                if (!old.equals(o)) continue;
                logger.info("update resource {} to {}", (Object)old, (Object)o);
                i.remove();
                this.list.add(o);
                boolean bl = false;
                return bl;
            }
            logger.debug("add resource {} to selector", (Object)o);
            this.list.add(o);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

