/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.transport.http.client;

import com.ejtone.mars.kernel.util.JsonUtil;
import com.ejtone.mars.kernel.util.MixUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String client(String url, Object object) {
        String res = "";
        HttpPost post = new HttpPost(url);
        ContentType contenttype = ContentType.APPLICATION_JSON.withCharset(Charset.forName("UTF-8"));
        HttpEntity entity = EntityBuilder.create().setText(JsonUtil.toJsonString(object)).setContentType(contenttype).build();
        post.setEntity(entity);
        logger.info("test, url = {}", (Object)url);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        try {
            response = client.execute(post);
            logger.info("statusCode = {}, line = {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            HttpEntity resEntity = response.getEntity();
            if (resEntity == null) {
                String string = "";
                return string;
            }
            Charset resCharset = ContentType.getOrDefault(resEntity).getCharset();
            String contentCharset = resCharset == null ? HTTP.DEF_CONTENT_CHARSET.name() : resCharset.name();
            byte[] resData = EntityUtils.toByteArray(resEntity);
            res = new String(resData, contentCharset);
            logger.info("HttpClient = {} ", (Object)res);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MixUtil.safeClose(response);
            MixUtil.safeClose(client);
        }
        return res;
    }
}

