/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.transport.http.client;

import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.beans.factory.InitializingBean;

public class HttpClientHolder
implements InitializingBean {
    private int maxTotal = 2000;
    private int maxPerRoute = 200;
    private int connTimeout = 5000;
    private int requestTimeout = 5000;
    private int keepaliveTiemout = 1000;
    private CloseableHttpClient client;

    public static HttpClientHolder getInstance() {
        return InstanceHolder.instance;
    }

    private HttpClientHolder() {
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public HttpClientHolder setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
        return this;
    }

    public int getMaxPerRoute() {
        return this.maxPerRoute;
    }

    public HttpClientHolder setMaxPerRoute(int maxPerRoute) {
        this.maxPerRoute = maxPerRoute;
        return this;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public HttpClientHolder setConnTimeout(int connTimeout) {
        this.connTimeout = connTimeout;
        return this;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public HttpClientHolder setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public int getKeepaliveTiemout() {
        return this.keepaliveTiemout;
    }

    public HttpClientHolder setKeepaliveTiemout(int keepaliveTiemout) {
        this.keepaliveTiemout = keepaliveTiemout;
        return this;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.requestTimeout).setConnectTimeout(this.connTimeout).build();
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig);
        builder.evictExpiredConnections().evictIdleConnections(this.keepaliveTiemout, TimeUnit.MILLISECONDS);
        builder.setMaxConnTotal(this.maxTotal).setMaxConnPerRoute(this.maxPerRoute);
        builder.setSSLSocketFactory(HttpClientHolder.createSSLConnSocketFactory());
        this.client = builder.build();
    }

    private static SSLConnectionSocketFactory createSSLConnSocketFactory() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            @Override
            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        return new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
    }

    private static final class InstanceHolder {
        public static final HttpClientHolder instance = new HttpClientHolder();

        private InstanceHolder() {
        }
    }
}

