/*
 * Decompiled with CFR 0.152.
 */
package com.ejtone.mars.transport.http.server;

import com.ejtone.mars.kernel.util.MixUtil;
import com.ejtone.mars.kernel.util.config.ConfigUtils;
import com.ejtone.mars.kernel.util.lifecycle.AbstractLifeCycle;
import com.ejtone.mars.transport.http.server.DefaultHttpService;
import com.ejtone.mars.transport.http.server.FilterServer;
import com.ejtone.mars.transport.http.server.HttpService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.MultipartConfigElement;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer
extends AbstractLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(HttpServer.class);
    private String name = HttpServer.class.getName();
    private FilterServer server;
    private int port = 8080;
    private ServletContextHandler context = new ServletContextHandler(1);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.isRunning()) {
            logger.error("can not set port after server initialized");
            throw new IllegalStateException();
        }
        this.name = name;
    }

    public void setPort(int port) {
        if (this.isRunning()) {
            logger.error("can not set port after server initialized");
            throw new IllegalStateException();
        }
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServices(List<HttpService> services) {
        ServletContextHandler servletContextHandler = this.context;
        synchronized (servletContextHandler) {
            for (HttpService service : services) {
                String url = MixUtil.mergeUrl("/", service.getUrl());
                logger.info("regist url {} to service {}", (Object)url, (Object)service.getClass().getName());
                ServletHolder holder = new ServletHolder(service);
                if (service.isSupportMultiPart()) {
                    long maxFileSize = ConfigUtils.getInt("http.maxFileSize", 0x100000);
                    long maxReqSize = ConfigUtils.getInt("http.maxReqSize", 0x100000);
                    int fileSizeThreshold = ConfigUtils.getInt("http.fileSizeThreshold", 0x100000);
                    holder.getRegistration().setMultipartConfig(new MultipartConfigElement("data/tmp", maxFileSize, maxReqSize, fileSizeThreshold));
                }
                this.context.addServlet(holder, url);
            }
        }
    }

    @Override
    public void doStart() throws Exception {
        logger.info("http server bind port {}, starting...", (Object)this.port);
        this.server = new FilterServer();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.port);
        this.server.addConnector(connector);
        this.server.setHandler(this.context);
        long maxFormContentSize = ConfigUtils.getInt("http.maxFormContentSize", 200000);
        this.server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", maxFormContentSize);
        this.server.start();
    }

    @Override
    public void doStop() throws Exception {
        this.server.stop();
    }

    public static HttpServer createServer(String serverName, String serverUrl) throws MalformedURLException {
        try {
            URL url = new URL(serverUrl);
            HttpServer httpTransportServer = new HttpServer();
            DefaultHttpService service = new DefaultHttpService();
            service.setUrl(url.getPath());
            ArrayList<HttpService> services = new ArrayList<HttpService>();
            services.add(service);
            httpTransportServer.setPort(url.getPort());
            httpTransportServer.setName(serverName);
            httpTransportServer.setServices(services);
            return httpTransportServer;
        }
        catch (MalformedURLException e) {
            logger.error("serverUrl:{} is invalid", (Object)serverUrl);
            logger.error("exception:", e);
            throw e;
        }
    }
}

