/*
 * Decompiled with CFR 0.152.
 */
package com.mascloud.sdkclient;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejtone.mars.kernel.util.JsonUtil;
import com.ejtone.mars.kernel.util.NamedThreadFactory;
import com.ejtone.mars.transport.http.client.HttpClientHolder;
import com.mascloud.model.Account;
import com.mascloud.model.LoginReq;
import com.mascloud.model.MgcLoginRsp;
import com.mascloud.model.MoModel;
import com.mascloud.model.StatusReportModel;
import com.mascloud.model.SubmitReportModel;
import com.mascloud.model.SubmitReq;
import com.mascloud.model.SubmitRsp;
import com.mascloud.util.DateTimeUtil;
import com.mascloud.util.HttpUtil;
import com.mascloud.util.MD5Util;
import com.mascloud.util.McMgwError;
import com.mascloud.util.McRptStatus;
import com.mascloud.util.MixUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private final AtomicBoolean logined = new AtomicBoolean(false);
    private String sendUrl;
    public static final int SUCCESS = 1;
    public static final int NoopContent = 101;
    public static final int NullMobiles = 102;
    public static final int NoopMobiles = 103;
    public static final int IllegalMobiles = 104;
    public static final int UnAuth = 105;
    public static final int NoopSign = 106;
    public static final int InternalError = 107;
    public static final int JmsError = 108;
    public static final int DupMobiles = 109;
    public static final int Status_MaxMobiles = 110;
    public static final int NoopTempId = 111;
    public static final int ThreadPoolBusiz = 112;
    public static final int maxMobiles = 5000;
    public static final int maxQueueSize = 200000;
    public static final int requestInterval = 5;
    int num = 0;
    private String apId;
    private String apSecretKey;
    private String ecName;
    private int poolSize = 16;
    private int maxJobs = 8192;
    private final Lock reportLock = new ReentrantLock();
    private final Lock moLock = new ReentrantLock();
    private final ThreadPoolExecutor nThreadPool = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxJobs), new NamedThreadFactory("thread-sendDsms"));
    private final ScheduledThreadPoolExecutor moExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new NamedThreadFactory("sdk2.0-scheduled-getMo"));
    private List<MoModel> moModelList = new ArrayList<MoModel>();
    private final ScheduledThreadPoolExecutor reportExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new NamedThreadFactory("sdk2.0-scheduled-getReport"));
    private List<StatusReportModel> reportModelList = new ArrayList<StatusReportModel>();

    private Client() {
        this.reportExecutor.scheduleWithFixedDelay(new ReportTask(), 0L, 5L, TimeUnit.SECONDS);
        this.moExecutor.scheduleWithFixedDelay(new MoTask(), 0L, 5L, TimeUnit.SECONDS);
    }

    public static final Client getInstance() {
        return InstanceHolder.instance;
    }

    public String getSendUrl() {
        return this.sendUrl;
    }

    public void setSendUrl(String sendUrl) {
        this.sendUrl = sendUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String url, String userAccount, String password, String ecname) {
        Client client = this;
        synchronized (client) {
            if (this.logined.get()) {
                logger.error("user lgoined already");
                return true;
            }
        }
        LoginReq req = new LoginReq();
        req.setApId(userAccount);
        req.setSecretKey("");
        req.setEcName(ecname);
        try {
            MgcLoginRsp rsp = this.doLogin(url, req);
            if (rsp.isSuccess()) {
                this.sendUrl = rsp.getUrl();
                this.apId = userAccount;
                this.apSecretKey = password;
                this.ecName = ecname;
                this.logined.set(true);
            } else {
                logger.info("\u767b\u5f55\u5931\u8d25\uff1a{}", JSON.toJSON(rsp));
            }
        }
        catch (Exception e) {
            logger.info("\u767b\u5f55\u5f02\u5e38:", e);
        }
        return this.logined.get();
    }

    private MgcLoginRsp doLogin(String baseUrl, LoginReq req) throws Exception {
        MgcLoginRsp mgcLoginRsp;
        String url = MixUtil.mergeUrl(baseUrl, "/sms/login");
        CloseableHttpResponse resp = null;
        try {
            String reqText = JsonUtil.toJsonString(req);
            String encode = Base64.encodeBase64String(reqText.getBytes("utf-8"));
            logger.info("loginreq\t{}", (Object)reqText);
            resp = HttpUtil.post(url, encode, ContentType.APPLICATION_JSON);
            if (resp.getStatusLine().getStatusCode() != 200) {
                logger.error("login to {} exception, code = {}", (Object)url, (Object)resp.getStatusLine().getStatusCode());
                throw new RuntimeException("login exception");
            }
            String respText = HttpUtil.readHttpResponse(resp);
            if (StringUtils.isBlank(respText)) {
                logger.error("not found loginrsp data");
                throw new RuntimeException("login exception: not found loginrsp data");
            }
            logger.info("loginrsp\t{}", (Object)respText);
            mgcLoginRsp = JsonUtil.fromJsonString(respText, MgcLoginRsp.class);
        }
        catch (Exception e) {
            try {
                logger.error("login to {} exception, error = ", (Object)url, (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                HttpUtil.safeClose(resp);
                throw throwable;
            }
        }
        HttpUtil.safeClose(resp);
        return mgcLoginRsp;
    }

    public int sendDSMS(String[] mobiles, String smsContent, String addSerial, int smsPriority, String sign, String msgGroup, boolean isMo) {
        if (!this.logined.get()) {
            return 105;
        }
        if (mobiles == null) {
            return 102;
        }
        if (mobiles.length == 0) {
            return 103;
        }
        if (mobiles.length > 5000) {
            return 110;
        }
        HashSet<String> mbSet = new HashSet<String>();
        for (String mobile : mobiles) {
            mbSet.add(mobile);
        }
        if (mbSet.size() != mobiles.length) {
            return 109;
        }
        if (StringUtils.isBlank(smsContent)) {
            return 101;
        }
        if (StringUtils.isBlank(sign)) {
            return 106;
        }
        SubmitReq submit = new SubmitReq();
        submit.setApId(this.apId);
        submit.setApReqId(msgGroup != null ? msgGroup : MixUtil.uuid());
        if (StringUtils.isBlank(addSerial)) {
            addSerial = "";
        }
        if (StringUtils.isBlank(this.apSecretKey)) {
            this.apSecretKey = "";
        }
        submit.setMac(MD5Util.md5Encode(this.apId + this.apSecretKey + this.ecName + smsContent + sign + addSerial));
        submit.setContent(smsContent);
        submit.setMobiles(new ArrayList<String>(mbSet));
        submit.setSrcId(addSerial);
        submit.setServiceId(sign);
        submit.setRegReport(isMo);
        submit.setEcName(this.ecName);
        Runnable task = null;
        try {
            task = new SubmitTask(submit, mobiles, this.sendUrl);
            this.nThreadPool.execute(new SubmitTask(submit, mobiles, this.sendUrl));
            return 1;
        }
        catch (RejectedExecutionException e) {
            task.run();
            return 112;
        }
    }

    public int sendTSMS(String[] mobiles, String tempID, String[] params, String addSerial, int smsPriority, String sign, String msgGroup) {
        if (!this.logined.get()) {
            return 105;
        }
        if (mobiles == null) {
            return 102;
        }
        if (mobiles.length == 0) {
            return 103;
        }
        if (mobiles.length > 5000) {
            return 110;
        }
        HashSet<String> mbSet = new HashSet<String>();
        for (String mobile : mobiles) {
            mbSet.add(mobile);
        }
        if (mbSet.size() != mobiles.length) {
            return 109;
        }
        if (params == null || params.length == 0) {
            return 101;
        }
        if (StringUtils.isBlank(sign)) {
            return 106;
        }
        if (StringUtils.isBlank(tempID)) {
            return 111;
        }
        SubmitReq submit = new SubmitReq();
        submit.setApId(this.apId);
        submit.setApReqId(msgGroup != null ? msgGroup : MixUtil.uuid());
        submit.setMac(MD5Util.md5Encode(this.apId + this.apSecretKey + this.ecName + tempID + sign + addSerial));
        submit.setContent(JsonUtil.toJsonString(params));
        submit.setMobiles(new ArrayList<String>(mbSet));
        submit.setSrcId(addSerial);
        submit.setServiceId(sign);
        submit.setRegReport(true);
        submit.setTemplateId(tempID);
        submit.setEcName(this.ecName);
        Runnable task = null;
        try {
            task = new SubmitTask(submit, mobiles, this.sendUrl);
            this.nThreadPool.execute(new SubmitTask(submit, mobiles, this.sendUrl));
            return 1;
        }
        catch (RejectedExecutionException e) {
            task.run();
            return 112;
        }
    }

    private SubmitRsp doSubmit(String baseUrl, SubmitReq req) throws Exception {
        SubmitRsp submitRsp;
        String url = MixUtil.mergeUrl(baseUrl, "/sms/submit");
        CloseableHttpResponse resp = null;
        try {
            String reqText = JsonUtil.toJsonString(req);
            logger.info("submitreq\t{}", (Object)reqText);
            String encode = Base64.encodeBase64String(reqText.getBytes("utf-8"));
            resp = HttpUtil.post(url, encode, ContentType.APPLICATION_JSON);
            if (resp.getStatusLine().getStatusCode() != 200) {
                logger.error("submit to {} exception, code = {}", (Object)url, (Object)resp.getStatusLine().getStatusCode());
                throw new RuntimeException("submit exception");
            }
            String respText = HttpUtil.readHttpResponse(resp);
            if (StringUtils.isBlank(respText)) {
                logger.error("not found submitrsp data");
                throw new RuntimeException("submit exception:not found submitrsp data");
            }
            logger.info("submitrsp\t{}", (Object)respText);
            submitRsp = JsonUtil.fromJsonString(respText, SubmitRsp.class);
        }
        catch (Exception e) {
            try {
                logger.error("submit to {} exception, error = ", (Object)url, (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                HttpUtil.safeClose(resp);
                throw throwable;
            }
        }
        HttpUtil.safeClose(resp);
        return submitRsp;
    }

    private String parseSubmitStatus(String rspcod) {
        if (McMgwError.InvalidUsrOrPwd.becauseOf(rspcod)) {
            return McRptStatus.INVALID_USR_OR_PWD.getStatus();
        }
        if (McMgwError.InvalidMessage.becauseOf(rspcod)) {
            return McRptStatus.INVALID_MESSAGE.getStatus();
        }
        if (McMgwError.NO_SIGN_ID.becauseOf(rspcod)) {
            return McRptStatus.NO_SIGN_ID.getStatus();
        }
        if (McMgwError.TOO_MANY_MOBILES.becauseOf(rspcod)) {
            return McRptStatus.TOO_MANY_MOBILES.getStatus();
        }
        if (McMgwError.ILLEGAL_SIGN_ID.becauseOf(rspcod)) {
            return McRptStatus.ILLEGAL_SIGN_ID.getStatus();
        }
        return "CM:9999";
    }

    private List<StatusReportModel> doReport(String baseUrl, Account accout) throws Exception {
        ArrayList<StatusReportModel> arrayList;
        ArrayList<StatusReportModel> statusReport = new ArrayList();
        String url = MixUtil.mergeUrl(baseUrl, "/sms/report");
        CloseableHttpResponse resp = null;
        try {
            String reqText = JsonUtil.toJsonString(accout);
            logger.info("reportAccount\t{}", (Object)reqText);
            String encode = Base64.encodeBase64String(reqText.getBytes("utf-8"));
            resp = HttpUtil.post(url, encode, ContentType.APPLICATION_JSON);
            if (resp.getStatusLine().getStatusCode() != 200) {
                logger.error("report submit to {} exception, code = {}", (Object)url, (Object)resp.getStatusLine().getStatusCode());
                throw new RuntimeException("report submit exception");
            }
            String respText = HttpUtil.readHttpResponse(resp);
            if (StringUtils.isBlank(respText)) {
                logger.error("not found submitrsp data");
                throw new RuntimeException("report submit exception : not found submitrsp data");
            }
            logger.info("report submitrsp\t{}", (Object)respText);
            try {
                statusReport = JSONArray.parseArray(respText, StatusReportModel.class);
            }
            catch (Exception e) {
                statusReport = new ArrayList();
            }
            arrayList = statusReport;
        }
        catch (Exception e) {
            try {
                logger.error("submit to {} exception, error = ", (Object)url, (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                HttpUtil.safeClose(resp);
                throw throwable;
            }
        }
        HttpUtil.safeClose(resp);
        return arrayList;
    }

    public List<StatusReportModel> getReport() {
        if (!this.logined.get()) {
            logger.error("\u83b7\u53d6\u72b6\u6001\u62a5\u544a\u5931\u8d25\uff1a\u8bf7\u5148\u767b\u9646\uff01");
            return null;
        }
        this.reportLock.lock();
        try {
            List<StatusReportModel> statusReportModels = this.reportModelList;
            this.reportModelList = new ArrayList<StatusReportModel>();
            List<StatusReportModel> list = statusReportModels;
            return list;
        }
        finally {
            this.reportLock.unlock();
        }
    }

    private List<MoModel> getMoMessage(String baseUrl, Account accout) throws Exception {
        ArrayList<MoModel> arrayList;
        ArrayList<MoModel> statusReport = new ArrayList();
        String url = MixUtil.mergeUrl(baseUrl, "/sms/deliver");
        CloseableHttpResponse resp = null;
        try {
            String reqText = JsonUtil.toJsonString(accout);
            logger.info("moAccount\t{}", (Object)reqText);
            String encode = Base64.encodeBase64String(reqText.getBytes("utf-8"));
            resp = HttpUtil.post(url, encode, ContentType.APPLICATION_JSON);
            if (resp.getStatusLine().getStatusCode() != 200) {
                logger.error("getMo submit to {} exception, code = {}", (Object)url, (Object)resp.getStatusLine().getStatusCode());
                throw new RuntimeException("getMo submit exception");
            }
            String respText = HttpUtil.readHttpResponse(resp);
            if (StringUtils.isBlank(respText)) {
                logger.error("not found submitrsp data");
                throw new RuntimeException("getMo submit exception : not found submitrsp data");
            }
            logger.info("mo submitrsp\t{}", (Object)respText);
            try {
                statusReport = JSONArray.parseArray(respText, MoModel.class);
            }
            catch (Exception e) {
                statusReport = new ArrayList();
            }
            arrayList = statusReport;
        }
        catch (Exception e) {
            try {
                logger.error("submit to {} exception, error = ", (Object)url, (Object)e);
                throw e;
            }
            catch (Throwable throwable) {
                HttpUtil.safeClose(resp);
                throw throwable;
            }
        }
        HttpUtil.safeClose(resp);
        return arrayList;
    }

    public List<MoModel> getMO() {
        if (!this.logined.get()) {
            logger.error("\u83b7\u53d6\u4e0a\u884c\u6d88\u606f\u5931\u8d25\uff1a\u8bf7\u5148\u767b\u9646\uff01");
            return null;
        }
        this.moLock.lock();
        try {
            List<MoModel> moModels = this.moModelList;
            this.moModelList = new ArrayList<MoModel>();
            List<MoModel> list = moModels;
            return list;
        }
        finally {
            this.moLock.unlock();
        }
    }

    static {
        try {
            HttpClientHolder.getInstance().afterPropertiesSet();
        }
        catch (Exception e) {
            logger.error("", e);
        }
    }

    public final class SubmitTask
    implements Runnable {
        private SubmitReq submit;
        private String[] mobiles;
        private String sendUrl;

        public SubmitTask(SubmitReq submit, String[] mobiles, String sendUrl) {
            this.submit = submit;
            this.mobiles = mobiles;
            this.sendUrl = sendUrl;
        }

        @Override
        public void run() {
            SubmitReportModel model = null;
            SubmitReportModel model2 = null;
            try {
                SubmitRsp rsp = Client.this.doSubmit(this.sendUrl, this.submit);
                model = new SubmitReportModel();
                model.setMobiles(this.mobiles);
                model.setMsgGroup(this.submit.getApReqId());
                model.setReportStatus(rsp.isSuccess() ? "CM:0000" : Client.this.parseSubmitStatus(rsp.getRspcod()));
                model.setSubmitDate(DateTimeUtil.getDate());
                model.setReceiveDate(DateTimeUtil.getDate());
                model.setErrorCode(rsp.getRspcod());
                if (rsp.isSuccess()) {
                    model2 = new SubmitReportModel();
                    model2.setMobiles(this.mobiles);
                    model2.setMsgGroup(this.submit.getApReqId());
                    model2.setReportStatus("CM:3000");
                    model2.setSubmitDate(DateTimeUtil.getDate());
                    model2.setReceiveDate(DateTimeUtil.getDate());
                    model2.setErrorCode(rsp.getRspcod());
                }
            }
            catch (Exception e) {
                model = new SubmitReportModel();
                model.setMobiles(this.mobiles);
                model.setMsgGroup(this.submit.getApReqId());
                model.setReportStatus("\u53d1\u9001\u9519\u8bef");
                model.setSubmitDate(DateTimeUtil.getDate());
                model.setReceiveDate(DateTimeUtil.getDate());
                model.setErrorCode("CM:9999");
            }
        }
    }

    public final class ReportTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!Client.this.logined.get()) {
                return;
            }
            if (StringUtils.isBlank(Client.this.apId) || StringUtils.isBlank(Client.this.ecName)) {
                logger.error("apId / ecName is null ,query stop!");
                return;
            }
            Account accout = new Account(Client.this.apId, Client.this.apSecretKey, Client.this.ecName);
            List report = new ArrayList();
            Client.this.reportLock.lock();
            try {
                report = Client.this.doReport(Client.this.sendUrl, accout);
                if (Client.this.reportModelList.size() < 200000) {
                    Client.this.reportModelList.addAll(report);
                } else {
                    logger.info("Report:\u672c\u5730\u7f13\u5b58\u5df2\u8d8520\u4e07\u6570\u636e\uff0c\u4ee5\u4e0b\u6570\u636e\u5c06\u88ab\u4e22\u5f03\uff1a{}", (Object)JsonUtil.toJsonString(report));
                }
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u72b6\u6001\u62a5\u544a\u5931\u8d25\uff1a", e);
            }
            finally {
                Client.this.reportLock.unlock();
            }
        }
    }

    public final class MoTask
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!Client.this.logined.get()) {
                return;
            }
            if (StringUtils.isBlank(Client.this.apId) || StringUtils.isBlank(Client.this.ecName)) {
                logger.error("apId / ecName is null ,query stop!");
                return;
            }
            Account accout = new Account(Client.this.apId, Client.this.apSecretKey, Client.this.ecName);
            List mo = new ArrayList();
            Client.this.moLock.lock();
            try {
                mo = Client.this.getMoMessage(Client.this.sendUrl, accout);
                if (Client.this.moModelList.size() < 200000) {
                    Client.this.moModelList.addAll(mo);
                } else {
                    logger.info("Deliver:\u672c\u5730\u7f13\u5b58\u5df2\u8d8520\u4e07\u6570\u636e\uff0c\u4ee5\u4e0b\u6570\u636e\u5c06\u88ab\u4e22\u5f03\uff1a{}", (Object)JsonUtil.toJsonString(mo));
                }
            }
            catch (Exception e) {
                logger.info("\u83b7\u53d6\u4e0a\u884c\u77ed\u4fe1\u5931\u8d25\uff1a", e);
            }
            finally {
                Client.this.moLock.unlock();
            }
        }
    }

    private static final class InstanceHolder {
        public static final Client instance = new Client();

        private InstanceHolder() {
        }
    }
}

