/*
 * Decompiled with CFR 0.152.
 */
package com.mascloud.util;

import com.mascloud.util.HexDumper;
import com.mascloud.util.MsgFormat;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class MarsMsgUtil {
    public static final byte LONG_SM_CODE_HEAD_0 = 5;
    public static final byte LONG_SM_CODE_HEAD_1 = 0;
    public static final byte LONG_SM_CODE_HEAD_2 = 3;
    public static final byte LONG_SM_CODE2_HEAD_0 = 6;
    public static final byte LONG_SM_CODE2_HEAD_1 = 8;
    public static final byte LONG_SM_CODE2_HEAD_2 = 4;
    public static final int L6_MSG_CNT_INDEX = 4;
    public static final int L6_MSG_SEQ_INDEX = 5;
    public static final int L7_MSG_CNT_INDEX = 5;
    public static final int L7_MSG_SEQ_INDEX = 6;

    public static String getBillContent(byte[] contents, int msgfmt, int udhi) {
        if (udhi == 0) {
            return MsgFormat.parse(msgfmt).toReadableString(contents);
        }
        if (udhi == 1) {
            if (MarsMsgUtil.isSMSTypeL6(contents)) {
                return MarsMsgUtil.getLmsHead(contents) + MsgFormat.parse(msgfmt).toReadableString(ArrayUtils.subarray(contents, 6, contents.length)).replaceAll("\n|\r", "");
            }
            if (MarsMsgUtil.isSMSTypeL7(contents)) {
                return MarsMsgUtil.getLmsHead(contents) + MsgFormat.parse(msgfmt).toReadableString(ArrayUtils.subarray(contents, 7, contents.length)).replaceAll("\n|\r", "");
            }
            return HexDumper.getHexdump(contents);
        }
        return HexDumper.getHexdump(contents);
    }

    public static String getPrintableContent(byte[] contents, int msgfmt, int udhi) {
        if (udhi == 0) {
            return MsgFormat.parse(msgfmt).toReadableString(contents);
        }
        if (udhi == 1) {
            if (MarsMsgUtil.isSMSTypeL6(contents)) {
                return HexDumper.getHexdump(ArrayUtils.subarray(contents, 0, 6)) + MsgFormat.parse(msgfmt).toReadableString(ArrayUtils.subarray(contents, 6, contents.length)).replaceAll("\n|\r", "");
            }
            if (MarsMsgUtil.isSMSTypeL7(contents)) {
                return HexDumper.getHexdump(ArrayUtils.subarray(contents, 0, 7)) + MsgFormat.parse(msgfmt).toReadableString(ArrayUtils.subarray(contents, 7, contents.length)).replaceAll("\n|\r", "");
            }
            return HexDumper.getHexdump(contents);
        }
        return HexDumper.getHexdump(contents);
    }

    public static String getStringContent(byte[] contents, int msgfmt, int udhi) {
        if (udhi == 0) {
            return MsgFormat.parse(msgfmt).getContent(contents);
        }
        if (udhi == 1) {
            if (MarsMsgUtil.isSMSTypeL6(contents)) {
                return MsgFormat.parse(msgfmt).getContent(ArrayUtils.subarray(contents, 6, contents.length));
            }
            if (MarsMsgUtil.isSMSTypeL7(contents)) {
                return MsgFormat.parse(msgfmt).getContent(ArrayUtils.subarray(contents, 7, contents.length));
            }
            return "";
        }
        return "";
    }

    public static boolean isLongSMS(byte[] content, int udhi) {
        return udhi == 1 ? MarsMsgUtil.isSMSTypeL6(content) || MarsMsgUtil.isSMSTypeL7(content) : false;
    }

    public static boolean isContentLongSMS(byte[] content) {
        return MarsMsgUtil.isSMSTypeL6(content) || MarsMsgUtil.isSMSTypeL7(content);
    }

    public static boolean isSMSTypeL6(byte[] content) {
        return content != null && content.length > 6 && content[0] == 5 && content[1] == 0 && content[2] == 3;
    }

    public static boolean isSMSTypeL7(byte[] content) {
        return content != null && content.length > 7 && content[0] == 6 && content[1] == 8 && content[2] == 4;
    }

    public static byte getMsgCnt(byte[] content) {
        if (MarsMsgUtil.isContentLongSMS(content)) {
            if (MarsMsgUtil.isSMSTypeL6(content)) {
                return content[4];
            }
            return content[5];
        }
        return 1;
    }

    public static byte getMsgSeq(byte[] content) {
        if (MarsMsgUtil.isContentLongSMS(content)) {
            if (MarsMsgUtil.isSMSTypeL6(content)) {
                return content[5];
            }
            return content[6];
        }
        return 1;
    }

    public static int getLongSMSSeq(byte[] contents, int udhi) {
        if (udhi == 1) {
            if (MarsMsgUtil.isSMSTypeL6(contents)) {
                return contents[3] & 0xFF;
            }
            if (MarsMsgUtil.isSMSTypeL7(contents)) {
                return (contents[3] & 0xFF) << 8 | contents[4] & 0xFF;
            }
        }
        return -1;
    }

    public static String getLmsHead(byte[] contents) {
        return "(" + MarsMsgUtil.getMsgSeq(contents) + "/" + MarsMsgUtil.getMsgCnt(contents) + ")";
    }

    public static String getNoPrefixMobileNumber(String number) {
        return number == null ? number : number.replaceFirst("^\\+?0{0,2}86", "");
    }

    public static void transferNoPrefixMassMobileNumber(List<String> numbers) {
        if (numbers != null) {
            for (int i = 0; i < numbers.size(); ++i) {
                numbers.set(i, MarsMsgUtil.getNoPrefixMobileNumber(numbers.get(i)));
            }
        }
    }

    public static byte[] copySign(byte[] content, byte[] sign, boolean ahead) {
        return ahead ? ArrayUtils.addAll(sign, content) : ArrayUtils.addAll(content, sign);
    }

    public static void main(String[] args) {
        String s = "aaaa\rbbbb\nccc";
        System.out.println(s);
        System.out.println(s.replaceAll("\n|\r", ""));
    }
}

