/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.openhft.lang.Maths;

class VanillaDateCache {
    private static final int SIZE = 32;
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final SimpleDateFormat format;
    private final DateValue[] values = new DateValue[32];
    private final int cycleLength;

    public VanillaDateCache(String formatStr, int cycleLength) {
        this.cycleLength = cycleLength;
        this.format = new SimpleDateFormat(formatStr);
        this.format.setTimeZone(GMT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatFor(int cycle) {
        long millis = (long)cycle * (long)this.cycleLength;
        int hash = (int)Maths.hash(millis) & 0x1F;
        DateValue dv = this.values[hash];
        if (dv == null || dv.millis != millis) {
            SimpleDateFormat simpleDateFormat = this.format;
            synchronized (simpleDateFormat) {
                String text = this.format.format(new Date(millis));
                this.values[hash] = new DateValue(millis, text);
                return text;
            }
        }
        return dv.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseCount(String name) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            return this.format.parse(name).getTime() / (long)this.cycleLength;
        }
    }

    static class DateValue {
        final long millis;
        final String text;

        DateValue(long millis, String text) {
            this.millis = millis;
            this.text = text;
        }
    }
}

